@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.CreateRecoveryPlanInputPropertiesArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.FailoverDeploymentModel
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Recovery plan creation properties.
 * @property failoverDeploymentModel The failover deployment model.
 * @property groups The recovery plan groups.
 * @property primaryFabricId The primary fabric Id.
 * @property providerSpecificInput The provider specific input.
 * @property recoveryFabricId The recovery fabric Id.
 */
public data class CreateRecoveryPlanInputPropertiesArgs(
    public val failoverDeploymentModel: Output<Either<String, FailoverDeploymentModel>>? = null,
    public val groups: Output<List<RecoveryPlanGroupArgs>>,
    public val primaryFabricId: Output<String>,
    public val providerSpecificInput: Output<List<RecoveryPlanA2AInputArgs>>? = null,
    public val recoveryFabricId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.CreateRecoveryPlanInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.CreateRecoveryPlanInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.CreateRecoveryPlanInputPropertiesArgs.builder()
            .failoverDeploymentModel(
                failoverDeploymentModel?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .groups(groups.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .primaryFabricId(primaryFabricId.applyValue({ args0 -> args0 }))
            .providerSpecificInput(
                providerSpecificInput?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .recoveryFabricId(recoveryFabricId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CreateRecoveryPlanInputPropertiesArgs].
 */
@PulumiTagMarker
public class CreateRecoveryPlanInputPropertiesArgsBuilder internal constructor() {
    private var failoverDeploymentModel: Output<Either<String, FailoverDeploymentModel>>? = null

    private var groups: Output<List<RecoveryPlanGroupArgs>>? = null

    private var primaryFabricId: Output<String>? = null

    private var providerSpecificInput: Output<List<RecoveryPlanA2AInputArgs>>? = null

    private var recoveryFabricId: Output<String>? = null

    /**
     * @param value The failover deployment model.
     */
    @JvmName("kayihbadnnhrulor")
    public suspend
    fun failoverDeploymentModel(`value`: Output<Either<String, FailoverDeploymentModel>>) {
        this.failoverDeploymentModel = value
    }

    /**
     * @param value The recovery plan groups.
     */
    @JvmName("tuamtcqymacrykdq")
    public suspend fun groups(`value`: Output<List<RecoveryPlanGroupArgs>>) {
        this.groups = value
    }

    @JvmName("aanrgwduksxgdrvp")
    public suspend fun groups(vararg values: Output<RecoveryPlanGroupArgs>) {
        this.groups = Output.all(values.asList())
    }

    /**
     * @param values The recovery plan groups.
     */
    @JvmName("lvlwsmndrnrkvowb")
    public suspend fun groups(values: List<Output<RecoveryPlanGroupArgs>>) {
        this.groups = Output.all(values)
    }

    /**
     * @param value The primary fabric Id.
     */
    @JvmName("yufxdstrwiasfunx")
    public suspend fun primaryFabricId(`value`: Output<String>) {
        this.primaryFabricId = value
    }

    /**
     * @param value The provider specific input.
     */
    @JvmName("xvyjtwkkkytndvfw")
    public suspend fun providerSpecificInput(`value`: Output<List<RecoveryPlanA2AInputArgs>>) {
        this.providerSpecificInput = value
    }

    @JvmName("utuvmdoyxnuporvr")
    public suspend fun providerSpecificInput(vararg values: Output<RecoveryPlanA2AInputArgs>) {
        this.providerSpecificInput = Output.all(values.asList())
    }

    /**
     * @param values The provider specific input.
     */
    @JvmName("appjlncxdpvocbmk")
    public suspend fun providerSpecificInput(values: List<Output<RecoveryPlanA2AInputArgs>>) {
        this.providerSpecificInput = Output.all(values)
    }

    /**
     * @param value The recovery fabric Id.
     */
    @JvmName("diqwfyavhxcqbgvd")
    public suspend fun recoveryFabricId(`value`: Output<String>) {
        this.recoveryFabricId = value
    }

    /**
     * @param value The failover deployment model.
     */
    @JvmName("cbrxtdtcpfhqfmnh")
    public suspend fun failoverDeploymentModel(`value`: Either<String, FailoverDeploymentModel>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failoverDeploymentModel = mapped
    }

    /**
     * @param value The failover deployment model.
     */
    @JvmName("idxoisfwwmxejhrl")
    public fun failoverDeploymentModel(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FailoverDeploymentModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverDeploymentModel = mapped
    }

    /**
     * @param value The failover deployment model.
     */
    @JvmName("lswdecbibrcgiqfd")
    public fun failoverDeploymentModel(`value`: FailoverDeploymentModel) {
        val toBeMapped = Either.ofRight<String, FailoverDeploymentModel>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.failoverDeploymentModel = mapped
    }

    /**
     * @param value The recovery plan groups.
     */
    @JvmName("vfypantibshikavo")
    public suspend fun groups(`value`: List<RecoveryPlanGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param argument The recovery plan groups.
     */
    @JvmName("qofiwfgmkreywiua")
    public suspend fun groups(argument: List<suspend RecoveryPlanGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument The recovery plan groups.
     */
    @JvmName("xrvqhvqkfntcmvpp")
    public suspend fun groups(vararg argument: suspend RecoveryPlanGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param argument The recovery plan groups.
     */
    @JvmName("imrwtrushwcigxfp")
    public suspend fun groups(argument: suspend RecoveryPlanGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecoveryPlanGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.groups = mapped
    }

    /**
     * @param values The recovery plan groups.
     */
    @JvmName("kwkvmigdmllmwphf")
    public suspend fun groups(vararg values: RecoveryPlanGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groups = mapped
    }

    /**
     * @param value The primary fabric Id.
     */
    @JvmName("vusrvqvbxkmptojx")
    public suspend fun primaryFabricId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.primaryFabricId = mapped
    }

    /**
     * @param value The provider specific input.
     */
    @JvmName("wepdrudrvoyrocps")
    public suspend fun providerSpecificInput(`value`: List<RecoveryPlanA2AInputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    /**
     * @param argument The provider specific input.
     */
    @JvmName("xarnceycqnlbdyqr")
    public suspend
    fun providerSpecificInput(argument: List<suspend RecoveryPlanA2AInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanA2AInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.providerSpecificInput = mapped
    }

    /**
     * @param argument The provider specific input.
     */
    @JvmName("ngtgfcjipnattkok")
    public suspend fun providerSpecificInput(
        vararg
        argument: suspend RecoveryPlanA2AInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            RecoveryPlanA2AInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.providerSpecificInput = mapped
    }

    /**
     * @param argument The provider specific input.
     */
    @JvmName("niubgbiubhlwyobq")
    public suspend
    fun providerSpecificInput(argument: suspend RecoveryPlanA2AInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RecoveryPlanA2AInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.providerSpecificInput = mapped
    }

    /**
     * @param values The provider specific input.
     */
    @JvmName("hxkhexhpvldvcpqx")
    public suspend fun providerSpecificInput(vararg values: RecoveryPlanA2AInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.providerSpecificInput = mapped
    }

    /**
     * @param value The recovery fabric Id.
     */
    @JvmName("jjhpwibetdxeetkx")
    public suspend fun recoveryFabricId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryFabricId = mapped
    }

    internal fun build(): CreateRecoveryPlanInputPropertiesArgs =
        CreateRecoveryPlanInputPropertiesArgs(
            failoverDeploymentModel = failoverDeploymentModel,
            groups = groups ?: throw PulumiNullFieldException("groups"),
            primaryFabricId = primaryFabricId ?: throw PulumiNullFieldException("primaryFabricId"),
            providerSpecificInput = providerSpecificInput,
            recoveryFabricId = recoveryFabricId ?: throw PulumiNullFieldException("recoveryFabricId"),
        )
}
