@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Additional information of DPM Protected item.
 * @property diskStorageUsedInBytes Used Disk storage in bytes.
 * @property isCollocated To check if backup item is collocated.
 * @property isPresentOnCloud To check if backup item is cloud protected.
 * @property lastBackupStatus Last backup status information on backup item.
 * @property lastRefreshedAt Last refresh time on backup item.
 * @property oldestRecoveryPoint Oldest cloud recovery point time.
 * @property onPremiseLatestRecoveryPoint latest disk recovery point time.
 * @property onPremiseOldestRecoveryPoint Oldest disk recovery point time.
 * @property onPremiseRecoveryPointCount disk recovery point count.
 * @property protectableObjectLoadPath Attribute to provide information on various DBs.
 * @property protected To check if backup item is disk protected.
 * @property protectionGroupName Protection group name of the backup item.
 * @property recoveryPointCount cloud recovery point count.
 * @property totalDiskStorageSizeInBytes total Disk storage in bytes.
 */
public data class DPMProtectedItemExtendedInfoArgs(
    public val diskStorageUsedInBytes: Output<String>? = null,
    public val isCollocated: Output<Boolean>? = null,
    public val isPresentOnCloud: Output<Boolean>? = null,
    public val lastBackupStatus: Output<String>? = null,
    public val lastRefreshedAt: Output<String>? = null,
    public val oldestRecoveryPoint: Output<String>? = null,
    public val onPremiseLatestRecoveryPoint: Output<String>? = null,
    public val onPremiseOldestRecoveryPoint: Output<String>? = null,
    public val onPremiseRecoveryPointCount: Output<Int>? = null,
    public val protectableObjectLoadPath: Output<Map<String, String>>? = null,
    public val `protected`: Output<Boolean>? = null,
    public val protectionGroupName: Output<String>? = null,
    public val recoveryPointCount: Output<Int>? = null,
    public val totalDiskStorageSizeInBytes: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemExtendedInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DPMProtectedItemExtendedInfoArgs.builder()
            .diskStorageUsedInBytes(diskStorageUsedInBytes?.applyValue({ args0 -> args0 }))
            .isCollocated(isCollocated?.applyValue({ args0 -> args0 }))
            .isPresentOnCloud(isPresentOnCloud?.applyValue({ args0 -> args0 }))
            .lastBackupStatus(lastBackupStatus?.applyValue({ args0 -> args0 }))
            .lastRefreshedAt(lastRefreshedAt?.applyValue({ args0 -> args0 }))
            .oldestRecoveryPoint(oldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .onPremiseLatestRecoveryPoint(onPremiseLatestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .onPremiseOldestRecoveryPoint(onPremiseOldestRecoveryPoint?.applyValue({ args0 -> args0 }))
            .onPremiseRecoveryPointCount(onPremiseRecoveryPointCount?.applyValue({ args0 -> args0 }))
            .protectableObjectLoadPath(
                protectableObjectLoadPath?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .protected_(`protected`?.applyValue({ args0 -> args0 }))
            .protectionGroupName(protectionGroupName?.applyValue({ args0 -> args0 }))
            .recoveryPointCount(recoveryPointCount?.applyValue({ args0 -> args0 }))
            .totalDiskStorageSizeInBytes(totalDiskStorageSizeInBytes?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DPMProtectedItemExtendedInfoArgs].
 */
@PulumiTagMarker
public class DPMProtectedItemExtendedInfoArgsBuilder internal constructor() {
    private var diskStorageUsedInBytes: Output<String>? = null

    private var isCollocated: Output<Boolean>? = null

    private var isPresentOnCloud: Output<Boolean>? = null

    private var lastBackupStatus: Output<String>? = null

    private var lastRefreshedAt: Output<String>? = null

    private var oldestRecoveryPoint: Output<String>? = null

    private var onPremiseLatestRecoveryPoint: Output<String>? = null

    private var onPremiseOldestRecoveryPoint: Output<String>? = null

    private var onPremiseRecoveryPointCount: Output<Int>? = null

    private var protectableObjectLoadPath: Output<Map<String, String>>? = null

    private var `protected`: Output<Boolean>? = null

    private var protectionGroupName: Output<String>? = null

    private var recoveryPointCount: Output<Int>? = null

    private var totalDiskStorageSizeInBytes: Output<String>? = null

    /**
     * @param value Used Disk storage in bytes.
     */
    @JvmName("marfobrmothivkqj")
    public suspend fun diskStorageUsedInBytes(`value`: Output<String>) {
        this.diskStorageUsedInBytes = value
    }

    /**
     * @param value To check if backup item is collocated.
     */
    @JvmName("oaeexkkqsvxlkldg")
    public suspend fun isCollocated(`value`: Output<Boolean>) {
        this.isCollocated = value
    }

    /**
     * @param value To check if backup item is cloud protected.
     */
    @JvmName("bupifoyymrodposs")
    public suspend fun isPresentOnCloud(`value`: Output<Boolean>) {
        this.isPresentOnCloud = value
    }

    /**
     * @param value Last backup status information on backup item.
     */
    @JvmName("xnmgnyexpbedcseq")
    public suspend fun lastBackupStatus(`value`: Output<String>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Last refresh time on backup item.
     */
    @JvmName("hnfcltfxalhaghjk")
    public suspend fun lastRefreshedAt(`value`: Output<String>) {
        this.lastRefreshedAt = value
    }

    /**
     * @param value Oldest cloud recovery point time.
     */
    @JvmName("olqnhhwxrssbimwj")
    public suspend fun oldestRecoveryPoint(`value`: Output<String>) {
        this.oldestRecoveryPoint = value
    }

    /**
     * @param value latest disk recovery point time.
     */
    @JvmName("ftqwibikqufnrdjr")
    public suspend fun onPremiseLatestRecoveryPoint(`value`: Output<String>) {
        this.onPremiseLatestRecoveryPoint = value
    }

    /**
     * @param value Oldest disk recovery point time.
     */
    @JvmName("swwhwqvjtbtwcvag")
    public suspend fun onPremiseOldestRecoveryPoint(`value`: Output<String>) {
        this.onPremiseOldestRecoveryPoint = value
    }

    /**
     * @param value disk recovery point count.
     */
    @JvmName("lsxjebsiststrooj")
    public suspend fun onPremiseRecoveryPointCount(`value`: Output<Int>) {
        this.onPremiseRecoveryPointCount = value
    }

    /**
     * @param value Attribute to provide information on various DBs.
     */
    @JvmName("qgofnybbjoghxpsc")
    public suspend fun protectableObjectLoadPath(`value`: Output<Map<String, String>>) {
        this.protectableObjectLoadPath = value
    }

    /**
     * @param value To check if backup item is disk protected.
     */
    @JvmName("sxrejgneobymivrp")
    public suspend fun `protected`(`value`: Output<Boolean>) {
        this.`protected` = value
    }

    /**
     * @param value Protection group name of the backup item.
     */
    @JvmName("ygllgadpoyujejdj")
    public suspend fun protectionGroupName(`value`: Output<String>) {
        this.protectionGroupName = value
    }

    /**
     * @param value cloud recovery point count.
     */
    @JvmName("fvwpqcbkrhrxgbcm")
    public suspend fun recoveryPointCount(`value`: Output<Int>) {
        this.recoveryPointCount = value
    }

    /**
     * @param value total Disk storage in bytes.
     */
    @JvmName("jhcxpmjwaqhnwfti")
    public suspend fun totalDiskStorageSizeInBytes(`value`: Output<String>) {
        this.totalDiskStorageSizeInBytes = value
    }

    /**
     * @param value Used Disk storage in bytes.
     */
    @JvmName("xjqyptbmswpruchh")
    public suspend fun diskStorageUsedInBytes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskStorageUsedInBytes = mapped
    }

    /**
     * @param value To check if backup item is collocated.
     */
    @JvmName("nivumxetwldopmnf")
    public suspend fun isCollocated(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isCollocated = mapped
    }

    /**
     * @param value To check if backup item is cloud protected.
     */
    @JvmName("lqwnykunqstnpibl")
    public suspend fun isPresentOnCloud(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPresentOnCloud = mapped
    }

    /**
     * @param value Last backup status information on backup item.
     */
    @JvmName("cenhxafyrxwqokac")
    public suspend fun lastBackupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Last refresh time on backup item.
     */
    @JvmName("drreqyljoudtvngq")
    public suspend fun lastRefreshedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRefreshedAt = mapped
    }

    /**
     * @param value Oldest cloud recovery point time.
     */
    @JvmName("kcygugsflaxwnwpt")
    public suspend fun oldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oldestRecoveryPoint = mapped
    }

    /**
     * @param value latest disk recovery point time.
     */
    @JvmName("ndpafccelrmvfikp")
    public suspend fun onPremiseLatestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremiseLatestRecoveryPoint = mapped
    }

    /**
     * @param value Oldest disk recovery point time.
     */
    @JvmName("ftjjwnpbnhhupuad")
    public suspend fun onPremiseOldestRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremiseOldestRecoveryPoint = mapped
    }

    /**
     * @param value disk recovery point count.
     */
    @JvmName("kcjadykkwodfkwor")
    public suspend fun onPremiseRecoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onPremiseRecoveryPointCount = mapped
    }

    /**
     * @param value Attribute to provide information on various DBs.
     */
    @JvmName("gtejuksedivkwvma")
    public suspend fun protectableObjectLoadPath(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableObjectLoadPath = mapped
    }

    /**
     * @param values Attribute to provide information on various DBs.
     */
    @JvmName("rjmjarkacwkoelrr")
    public fun protectableObjectLoadPath(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectableObjectLoadPath = mapped
    }

    /**
     * @param value To check if backup item is disk protected.
     */
    @JvmName("lehpxmtlmssodcuk")
    public suspend fun `protected`(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`protected` = mapped
    }

    /**
     * @param value Protection group name of the backup item.
     */
    @JvmName("wjebyclekaveeodb")
    public suspend fun protectionGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionGroupName = mapped
    }

    /**
     * @param value cloud recovery point count.
     */
    @JvmName("ilvgccgjkvqbqmdm")
    public suspend fun recoveryPointCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recoveryPointCount = mapped
    }

    /**
     * @param value total Disk storage in bytes.
     */
    @JvmName("qqifnyfvmuaykynw")
    public suspend fun totalDiskStorageSizeInBytes(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.totalDiskStorageSizeInBytes = mapped
    }

    internal fun build(): DPMProtectedItemExtendedInfoArgs = DPMProtectedItemExtendedInfoArgs(
        diskStorageUsedInBytes = diskStorageUsedInBytes,
        isCollocated = isCollocated,
        isPresentOnCloud = isPresentOnCloud,
        lastBackupStatus = lastBackupStatus,
        lastRefreshedAt = lastRefreshedAt,
        oldestRecoveryPoint = oldestRecoveryPoint,
        onPremiseLatestRecoveryPoint = onPremiseLatestRecoveryPoint,
        onPremiseOldestRecoveryPoint = onPremiseOldestRecoveryPoint,
        onPremiseRecoveryPointCount = onPremiseRecoveryPointCount,
        protectableObjectLoadPath = protectableObjectLoadPath,
        `protected` = `protected`,
        protectionGroupName = protectionGroupName,
        recoveryPointCount = recoveryPointCount,
        totalDiskStorageSizeInBytes = totalDiskStorageSizeInBytes,
    )
}
