@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.DistributedNodesInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * This is used to represent the various nodes of the distributed container.
 * @property nodeName Name of the node under a distributed container.
 * @property sourceResourceId ARM resource id of the node
 * @property status Status of this Node.
 * Failed | Succeeded
 */
public data class DistributedNodesInfoArgs(
    public val nodeName: Output<String>? = null,
    public val sourceResourceId: Output<String>? = null,
    public val status: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.DistributedNodesInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.DistributedNodesInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.DistributedNodesInfoArgs.builder()
            .nodeName(nodeName?.applyValue({ args0 -> args0 }))
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DistributedNodesInfoArgs].
 */
@PulumiTagMarker
public class DistributedNodesInfoArgsBuilder internal constructor() {
    private var nodeName: Output<String>? = null

    private var sourceResourceId: Output<String>? = null

    private var status: Output<String>? = null

    /**
     * @param value Name of the node under a distributed container.
     */
    @JvmName("lhrwaiowrovilths")
    public suspend fun nodeName(`value`: Output<String>) {
        this.nodeName = value
    }

    /**
     * @param value ARM resource id of the node
     */
    @JvmName("dahsuhohskdgiywl")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Status of this Node.
     * Failed | Succeeded
     */
    @JvmName("iadlyxuywhfahtvo")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value Name of the node under a distributed container.
     */
    @JvmName("mtqtckycysdeoseo")
    public suspend fun nodeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeName = mapped
    }

    /**
     * @param value ARM resource id of the node
     */
    @JvmName("xvvqjmqobvkhttlu")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    /**
     * @param value Status of this Node.
     * Failed | Succeeded
     */
    @JvmName("gmemmshtceipkwab")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): DistributedNodesInfoArgs = DistributedNodesInfoArgs(
        nodeName = nodeName,
        sourceResourceId = sourceResourceId,
        status = status,
    )
}
