@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.EnableProtectionInputPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Enable protection input properties.
 * @property policyId The Policy Id.
 * @property protectableItemId The protectable item Id.
 * @property providerSpecificDetails The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
 */
public data class EnableProtectionInputPropertiesArgs(
    public val policyId: Output<String>? = null,
    public val protectableItemId: Output<String>? = null,
    public val providerSpecificDetails: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.EnableProtectionInputPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.EnableProtectionInputPropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.EnableProtectionInputPropertiesArgs.builder()
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .protectableItemId(protectableItemId?.applyValue({ args0 -> args0 }))
            .providerSpecificDetails(providerSpecificDetails?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EnableProtectionInputPropertiesArgs].
 */
@PulumiTagMarker
public class EnableProtectionInputPropertiesArgsBuilder internal constructor() {
    private var policyId: Output<String>? = null

    private var protectableItemId: Output<String>? = null

    private var providerSpecificDetails: Output<Any>? = null

    /**
     * @param value The Policy Id.
     */
    @JvmName("kxwhtqnmaouekcld")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value The protectable item Id.
     */
    @JvmName("nqnsmxrgshhuqeht")
    public suspend fun protectableItemId(`value`: Output<String>) {
        this.protectableItemId = value
    }

    /**
     * @param value The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
     */
    @JvmName("jgbwsutvvskxsikt")
    public suspend fun providerSpecificDetails(`value`: Output<Any>) {
        this.providerSpecificDetails = value
    }

    /**
     * @param value The Policy Id.
     */
    @JvmName("qraiwehtulmwhphy")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value The protectable item Id.
     */
    @JvmName("chtmygrfbgwmigll")
    public suspend fun protectableItemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectableItemId = mapped
    }

    /**
     * @param value The ReplicationProviderInput. For HyperVReplicaAzure provider, it will be AzureEnableProtectionInput object. For San provider, it will be SanEnableProtectionInput object. For HyperVReplicaAzure provider, it can be null.
     */
    @JvmName("kmlofkkkichnulnn")
    public suspend fun providerSpecificDetails(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerSpecificDetails = mapped
    }

    internal fun build(): EnableProtectionInputPropertiesArgs = EnableProtectionInputPropertiesArgs(
        policyId = policyId,
        protectableItemId = protectableItemId,
        providerSpecificDetails = providerSpecificDetails,
    )
}
