@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GenericContainerExtendedInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Container extended information
 * @property containerIdentityInfo Container identity information
 * @property rawCertData Public key of container cert
 * @property serviceEndpoints Azure Backup Service Endpoints for the container
 */
public data class GenericContainerExtendedInfoArgs(
    public val containerIdentityInfo: Output<ContainerIdentityInfoArgs>? = null,
    public val rawCertData: Output<String>? = null,
    public val serviceEndpoints: Output<Map<String, String>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GenericContainerExtendedInfoArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GenericContainerExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GenericContainerExtendedInfoArgs.builder()
            .containerIdentityInfo(
                containerIdentityInfo?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .rawCertData(rawCertData?.applyValue({ args0 -> args0 }))
            .serviceEndpoints(
                serviceEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GenericContainerExtendedInfoArgs].
 */
@PulumiTagMarker
public class GenericContainerExtendedInfoArgsBuilder internal constructor() {
    private var containerIdentityInfo: Output<ContainerIdentityInfoArgs>? = null

    private var rawCertData: Output<String>? = null

    private var serviceEndpoints: Output<Map<String, String>>? = null

    /**
     * @param value Container identity information
     */
    @JvmName("htbprroconstmcjd")
    public suspend fun containerIdentityInfo(`value`: Output<ContainerIdentityInfoArgs>) {
        this.containerIdentityInfo = value
    }

    /**
     * @param value Public key of container cert
     */
    @JvmName("rolahisipdqwiiuy")
    public suspend fun rawCertData(`value`: Output<String>) {
        this.rawCertData = value
    }

    /**
     * @param value Azure Backup Service Endpoints for the container
     */
    @JvmName("fkvjoxcvediujsrl")
    public suspend fun serviceEndpoints(`value`: Output<Map<String, String>>) {
        this.serviceEndpoints = value
    }

    /**
     * @param value Container identity information
     */
    @JvmName("fkmjinnejgkyhnjn")
    public suspend fun containerIdentityInfo(`value`: ContainerIdentityInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerIdentityInfo = mapped
    }

    /**
     * @param argument Container identity information
     */
    @JvmName("imowdeptoqjbtcop")
    public suspend
    fun containerIdentityInfo(argument: suspend ContainerIdentityInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ContainerIdentityInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.containerIdentityInfo = mapped
    }

    /**
     * @param value Public key of container cert
     */
    @JvmName("fovjpdpowkijmstu")
    public suspend fun rawCertData(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rawCertData = mapped
    }

    /**
     * @param value Azure Backup Service Endpoints for the container
     */
    @JvmName("ymflfrrroxryvlmx")
    public suspend fun serviceEndpoints(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    /**
     * @param values Azure Backup Service Endpoints for the container
     */
    @JvmName("wvrhfbekvbjdhtmk")
    public fun serviceEndpoints(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceEndpoints = mapped
    }

    internal fun build(): GenericContainerExtendedInfoArgs = GenericContainerExtendedInfoArgs(
        containerIdentityInfo = containerIdentityInfo,
        rawCertData = rawCertData,
        serviceEndpoints = serviceEndpoints,
    )
}
