@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GenericProtectedItemArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.CreateMode
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ProtectionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Base class for backup items.
 * @property backupSetName Name of the backup set the backup item belongs to
 * @property containerName Unique name of container
 * @property createMode Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
 * @property deferredDeleteTimeInUTC Time for deferred deletion in UTC
 * @property deferredDeleteTimeRemaining Time remaining before the DS marked for deferred delete is permanently deleted
 * @property fabricName Name of this backup item's fabric.
 * @property friendlyName Friendly name of the container.
 * @property isArchiveEnabled Flag to identify whether datasource is protected in archive
 * @property isDeferredDeleteScheduleUpcoming Flag to identify whether the deferred deleted DS is to be purged soon
 * @property isRehydrate Flag to identify that deferred deleted DS is to be moved into Pause state
 * @property isScheduledForDeferredDelete Flag to identify whether the DS is scheduled for deferred delete
 * @property lastRecoveryPoint Timestamp when the last (latest) backup copy was created for this backup item.
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property policyName Name of the policy used for protection
 * @property policyState Indicates consistency of policy object and policy applied to this backup item.
 * @property protectedItemId Data Plane Service ID of the protected item.
 * @property protectedItemType backup item type.
 * Expected value is 'GenericProtectedItem'.
 * @property protectionState Backup state of this backup item.
 * @property resourceGuardOperationRequests ResourceGuardOperationRequests on which LAC check will be performed
 * @property softDeleteRetentionPeriodInDays Soft delete retention period in days
 * @property sourceAssociations Loosely coupled (type, value) associations (example - parent of a protected item)
 * @property sourceResourceId ARM ID of the resource to be backed up.
 */
public data class GenericProtectedItemArgs(
    public val backupSetName: Output<String>? = null,
    public val containerName: Output<String>? = null,
    public val createMode: Output<Either<String, CreateMode>>? = null,
    public val deferredDeleteTimeInUTC: Output<String>? = null,
    public val deferredDeleteTimeRemaining: Output<String>? = null,
    public val fabricName: Output<String>? = null,
    public val friendlyName: Output<String>? = null,
    public val isArchiveEnabled: Output<Boolean>? = null,
    public val isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null,
    public val isRehydrate: Output<Boolean>? = null,
    public val isScheduledForDeferredDelete: Output<Boolean>? = null,
    public val lastRecoveryPoint: Output<String>? = null,
    public val policyId: Output<String>? = null,
    public val policyName: Output<String>? = null,
    public val policyState: Output<String>? = null,
    public val protectedItemId: Output<Double>? = null,
    public val protectedItemType: Output<String>,
    public val protectionState: Output<Either<String, ProtectionState>>? = null,
    public val resourceGuardOperationRequests: Output<List<String>>? = null,
    public val softDeleteRetentionPeriodInDays: Output<Int>? = null,
    public val sourceAssociations: Output<Map<String, String>>? = null,
    public val sourceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GenericProtectedItemArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.GenericProtectedItemArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GenericProtectedItemArgs.builder()
            .backupSetName(backupSetName?.applyValue({ args0 -> args0 }))
            .containerName(containerName?.applyValue({ args0 -> args0 }))
            .createMode(
                createMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .deferredDeleteTimeInUTC(deferredDeleteTimeInUTC?.applyValue({ args0 -> args0 }))
            .deferredDeleteTimeRemaining(deferredDeleteTimeRemaining?.applyValue({ args0 -> args0 }))
            .fabricName(fabricName?.applyValue({ args0 -> args0 }))
            .friendlyName(friendlyName?.applyValue({ args0 -> args0 }))
            .isArchiveEnabled(isArchiveEnabled?.applyValue({ args0 -> args0 }))
            .isDeferredDeleteScheduleUpcoming(isDeferredDeleteScheduleUpcoming?.applyValue({ args0 -> args0 }))
            .isRehydrate(isRehydrate?.applyValue({ args0 -> args0 }))
            .isScheduledForDeferredDelete(isScheduledForDeferredDelete?.applyValue({ args0 -> args0 }))
            .lastRecoveryPoint(lastRecoveryPoint?.applyValue({ args0 -> args0 }))
            .policyId(policyId?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 }))
            .policyState(policyState?.applyValue({ args0 -> args0 }))
            .protectedItemId(protectedItemId?.applyValue({ args0 -> args0 }))
            .protectedItemType(protectedItemType.applyValue({ args0 -> args0 }))
            .protectionState(
                protectionState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGuardOperationRequests(
                resourceGuardOperationRequests?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .softDeleteRetentionPeriodInDays(softDeleteRetentionPeriodInDays?.applyValue({ args0 -> args0 }))
            .sourceAssociations(
                sourceAssociations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .sourceResourceId(sourceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GenericProtectedItemArgs].
 */
@PulumiTagMarker
public class GenericProtectedItemArgsBuilder internal constructor() {
    private var backupSetName: Output<String>? = null

    private var containerName: Output<String>? = null

    private var createMode: Output<Either<String, CreateMode>>? = null

    private var deferredDeleteTimeInUTC: Output<String>? = null

    private var deferredDeleteTimeRemaining: Output<String>? = null

    private var fabricName: Output<String>? = null

    private var friendlyName: Output<String>? = null

    private var isArchiveEnabled: Output<Boolean>? = null

    private var isDeferredDeleteScheduleUpcoming: Output<Boolean>? = null

    private var isRehydrate: Output<Boolean>? = null

    private var isScheduledForDeferredDelete: Output<Boolean>? = null

    private var lastRecoveryPoint: Output<String>? = null

    private var policyId: Output<String>? = null

    private var policyName: Output<String>? = null

    private var policyState: Output<String>? = null

    private var protectedItemId: Output<Double>? = null

    private var protectedItemType: Output<String>? = null

    private var protectionState: Output<Either<String, ProtectionState>>? = null

    private var resourceGuardOperationRequests: Output<List<String>>? = null

    private var softDeleteRetentionPeriodInDays: Output<Int>? = null

    private var sourceAssociations: Output<Map<String, String>>? = null

    private var sourceResourceId: Output<String>? = null

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("thupgagiqmpygkaa")
    public suspend fun backupSetName(`value`: Output<String>) {
        this.backupSetName = value
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("cctvakdruqfyuswk")
    public suspend fun containerName(`value`: Output<String>) {
        this.containerName = value
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("gwyslvsbdlysiwmt")
    public suspend fun createMode(`value`: Output<Either<String, CreateMode>>) {
        this.createMode = value
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("xymbukbqvjynfyut")
    public suspend fun deferredDeleteTimeInUTC(`value`: Output<String>) {
        this.deferredDeleteTimeInUTC = value
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("vbpwjrwqhysgolss")
    public suspend fun deferredDeleteTimeRemaining(`value`: Output<String>) {
        this.deferredDeleteTimeRemaining = value
    }

    /**
     * @param value Name of this backup item's fabric.
     */
    @JvmName("uyxcqbpdxfdcuvxc")
    public suspend fun fabricName(`value`: Output<String>) {
        this.fabricName = value
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("ftykbiqehkutscio")
    public suspend fun friendlyName(`value`: Output<String>) {
        this.friendlyName = value
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("ypbrlxxspijqosxp")
    public suspend fun isArchiveEnabled(`value`: Output<Boolean>) {
        this.isArchiveEnabled = value
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("thjdpfwmopojvntn")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Output<Boolean>) {
        this.isDeferredDeleteScheduleUpcoming = value
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("tugglexqjwxcxesw")
    public suspend fun isRehydrate(`value`: Output<Boolean>) {
        this.isRehydrate = value
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("lstarbaaikbsgiou")
    public suspend fun isScheduledForDeferredDelete(`value`: Output<Boolean>) {
        this.isScheduledForDeferredDelete = value
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("ptmkjpskmvoqkagm")
    public suspend fun lastRecoveryPoint(`value`: Output<String>) {
        this.lastRecoveryPoint = value
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("xhypaetltghpnrgl")
    public suspend fun policyId(`value`: Output<String>) {
        this.policyId = value
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("yjjsfnutrfyshimp")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("dfeousamkgpmcrll")
    public suspend fun policyState(`value`: Output<String>) {
        this.policyState = value
    }

    /**
     * @param value Data Plane Service ID of the protected item.
     */
    @JvmName("prafdhgsdcexetyd")
    public suspend fun protectedItemId(`value`: Output<Double>) {
        this.protectedItemId = value
    }

    /**
     * @param value backup item type.
     * Expected value is 'GenericProtectedItem'.
     */
    @JvmName("pkdtokacpvxfoulb")
    public suspend fun protectedItemType(`value`: Output<String>) {
        this.protectedItemType = value
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("axicvvmvxvqkcwed")
    public suspend fun protectionState(`value`: Output<Either<String, ProtectionState>>) {
        this.protectionState = value
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("kjcpdgkrecvskojg")
    public suspend fun resourceGuardOperationRequests(`value`: Output<List<String>>) {
        this.resourceGuardOperationRequests = value
    }

    @JvmName("hiqalxqhebuddaxt")
    public suspend fun resourceGuardOperationRequests(vararg values: Output<String>) {
        this.resourceGuardOperationRequests = Output.all(values.asList())
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("rrkwfvubyakrcwri")
    public suspend fun resourceGuardOperationRequests(values: List<Output<String>>) {
        this.resourceGuardOperationRequests = Output.all(values)
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("knsiklcfkexranku")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Output<Int>) {
        this.softDeleteRetentionPeriodInDays = value
    }

    /**
     * @param value Loosely coupled (type, value) associations (example - parent of a protected item)
     */
    @JvmName("ooobpaydfuhwgdue")
    public suspend fun sourceAssociations(`value`: Output<Map<String, String>>) {
        this.sourceAssociations = value
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("yivfrkdbjjeyocay")
    public suspend fun sourceResourceId(`value`: Output<String>) {
        this.sourceResourceId = value
    }

    /**
     * @param value Name of the backup set the backup item belongs to
     */
    @JvmName("gvuuntofqarijgkj")
    public suspend fun backupSetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupSetName = mapped
    }

    /**
     * @param value Unique name of container
     */
    @JvmName("cvqtqmhxgetdwpyl")
    public suspend fun containerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.containerName = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("arhcgrumoldhpnxa")
    public suspend fun createMode(`value`: Either<String, CreateMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("ahldgcbbhvbyiovs")
    public fun createMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Create mode to indicate recovery of existing soft deleted data source or creation of new data source.
     */
    @JvmName("hnfmmqgjctvejhwn")
    public fun createMode(`value`: CreateMode) {
        val toBeMapped = Either.ofRight<String, CreateMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Time for deferred deletion in UTC
     */
    @JvmName("wysegpvsndfhhbue")
    public suspend fun deferredDeleteTimeInUTC(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeInUTC = mapped
    }

    /**
     * @param value Time remaining before the DS marked for deferred delete is permanently deleted
     */
    @JvmName("hgvtrbcylmprtwtv")
    public suspend fun deferredDeleteTimeRemaining(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deferredDeleteTimeRemaining = mapped
    }

    /**
     * @param value Name of this backup item's fabric.
     */
    @JvmName("klmpvtcuaqogpxuj")
    public suspend fun fabricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fabricName = mapped
    }

    /**
     * @param value Friendly name of the container.
     */
    @JvmName("mpxkpnontjflusmo")
    public suspend fun friendlyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.friendlyName = mapped
    }

    /**
     * @param value Flag to identify whether datasource is protected in archive
     */
    @JvmName("pujmkgyvipemkmru")
    public suspend fun isArchiveEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isArchiveEnabled = mapped
    }

    /**
     * @param value Flag to identify whether the deferred deleted DS is to be purged soon
     */
    @JvmName("fxmcxvacolsfvxpe")
    public suspend fun isDeferredDeleteScheduleUpcoming(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isDeferredDeleteScheduleUpcoming = mapped
    }

    /**
     * @param value Flag to identify that deferred deleted DS is to be moved into Pause state
     */
    @JvmName("tsooasobemdjsatc")
    public suspend fun isRehydrate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isRehydrate = mapped
    }

    /**
     * @param value Flag to identify whether the DS is scheduled for deferred delete
     */
    @JvmName("ekjpddjakvfbaanq")
    public suspend fun isScheduledForDeferredDelete(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isScheduledForDeferredDelete = mapped
    }

    /**
     * @param value Timestamp when the last (latest) backup copy was created for this backup item.
     */
    @JvmName("ykwxossfudaqgyau")
    public suspend fun lastRecoveryPoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRecoveryPoint = mapped
    }

    /**
     * @param value ID of the backup policy with which this item is backed up.
     */
    @JvmName("frmvtwapgnxsmfhl")
    public suspend fun policyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyId = mapped
    }

    /**
     * @param value Name of the policy used for protection
     */
    @JvmName("wdljcxgqdgrwvisq")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    /**
     * @param value Indicates consistency of policy object and policy applied to this backup item.
     */
    @JvmName("kwcaldnwafixooof")
    public suspend fun policyState(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyState = mapped
    }

    /**
     * @param value Data Plane Service ID of the protected item.
     */
    @JvmName("lqtobpcmkaouyncq")
    public suspend fun protectedItemId(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectedItemId = mapped
    }

    /**
     * @param value backup item type.
     * Expected value is 'GenericProtectedItem'.
     */
    @JvmName("eyobnongfsxeytbg")
    public suspend fun protectedItemType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectedItemType = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("bhuvbjyvsblhiacf")
    public suspend fun protectionState(`value`: Either<String, ProtectionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("pkjsddwahmhftxby")
    public fun protectionState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value Backup state of this backup item.
     */
    @JvmName("pqdwpiteyktdxutp")
    public fun protectionState(`value`: ProtectionState) {
        val toBeMapped = Either.ofRight<String, ProtectionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionState = mapped
    }

    /**
     * @param value ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("naaxaqmdnhleqidr")
    public suspend fun resourceGuardOperationRequests(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param values ResourceGuardOperationRequests on which LAC check will be performed
     */
    @JvmName("jcduegrrycabwhao")
    public suspend fun resourceGuardOperationRequests(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceGuardOperationRequests = mapped
    }

    /**
     * @param value Soft delete retention period in days
     */
    @JvmName("clakmaytwcvrlyfe")
    public suspend fun softDeleteRetentionPeriodInDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.softDeleteRetentionPeriodInDays = mapped
    }

    /**
     * @param value Loosely coupled (type, value) associations (example - parent of a protected item)
     */
    @JvmName("ejwhdnuqjtomfddd")
    public suspend fun sourceAssociations(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceAssociations = mapped
    }

    /**
     * @param values Loosely coupled (type, value) associations (example - parent of a protected item)
     */
    @JvmName("ulfvioagwnpjpcuh")
    public fun sourceAssociations(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAssociations = mapped
    }

    /**
     * @param value ARM ID of the resource to be backed up.
     */
    @JvmName("xwxyipnvmmdcjgfw")
    public suspend fun sourceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceResourceId = mapped
    }

    internal fun build(): GenericProtectedItemArgs = GenericProtectedItemArgs(
        backupSetName = backupSetName,
        containerName = containerName,
        createMode = createMode,
        deferredDeleteTimeInUTC = deferredDeleteTimeInUTC,
        deferredDeleteTimeRemaining = deferredDeleteTimeRemaining,
        fabricName = fabricName,
        friendlyName = friendlyName,
        isArchiveEnabled = isArchiveEnabled,
        isDeferredDeleteScheduleUpcoming = isDeferredDeleteScheduleUpcoming,
        isRehydrate = isRehydrate,
        isScheduledForDeferredDelete = isScheduledForDeferredDelete,
        lastRecoveryPoint = lastRecoveryPoint,
        policyId = policyId,
        policyName = policyName,
        policyState = policyState,
        protectedItemId = protectedItemId,
        protectedItemType = protectedItemType ?: throw PulumiNullFieldException("protectedItemType"),
        protectionState = protectionState,
        resourceGuardOperationRequests = resourceGuardOperationRequests,
        softDeleteRetentionPeriodInDays = softDeleteRetentionPeriodInDays,
        sourceAssociations = sourceAssociations,
        sourceResourceId = sourceResourceId,
    )
}
