@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetPrivateEndpointConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateEndpointConnectionName The name of the private endpoint connection.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetPrivateEndpointConnectionPlainArgs(
    public val privateEndpointConnectionName: String,
    public val resourceGroupName: String,
    public val vaultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetPrivateEndpointConnectionPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetPrivateEndpointConnectionPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetPrivateEndpointConnectionPlainArgs.builder()
            .privateEndpointConnectionName(privateEndpointConnectionName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointConnectionPlainArgsBuilder internal constructor() {
    private var privateEndpointConnectionName: String? = null

    private var resourceGroupName: String? = null

    private var vaultName: String? = null

    /**
     * @param value The name of the private endpoint connection.
     */
    @JvmName("iysgeipgkbgefjrv")
    public suspend fun privateEndpointConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointConnectionName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("jfpyydcxxxufiemk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("llpjxsnenfjbjsvg")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetPrivateEndpointConnectionPlainArgs =
        GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName ?: throw
                PulumiNullFieldException("privateEndpointConnectionName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
        )
}
