@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetRecoveryPointAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property containerName Name of the container.
 * @property eTag Optional ETag.
 * @property fabricName Fabric name associated with the container.
 * @property location Resource location.
 * @property properties AADPropertiesResource properties
 * @property protectedItemName Name of the Protected Item.
 * @property recoveryPointId Recovery Point Id
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property tags Resource tags.
 * @property vaultName The name of the recovery services vault.
 */
public data class GetRecoveryPointAccessTokenPlainArgs(
    public val containerName: String,
    public val eTag: String? = null,
    public val fabricName: String,
    public val location: String? = null,
    public val properties: AADProperties? = null,
    public val protectedItemName: String,
    public val recoveryPointId: String,
    public val resourceGroupName: String,
    public val tags: Map<String, String>? = null,
    public val vaultName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetRecoveryPointAccessTokenPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetRecoveryPointAccessTokenPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetRecoveryPointAccessTokenPlainArgs.builder()
            .containerName(containerName.let({ args0 -> args0 }))
            .eTag(eTag?.let({ args0 -> args0 }))
            .fabricName(fabricName.let({ args0 -> args0 }))
            .location(location?.let({ args0 -> args0 }))
            .properties(properties?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .protectedItemName(protectedItemName.let({ args0 -> args0 }))
            .recoveryPointId(recoveryPointId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vaultName(vaultName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRecoveryPointAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class GetRecoveryPointAccessTokenPlainArgsBuilder internal constructor() {
    private var containerName: String? = null

    private var eTag: String? = null

    private var fabricName: String? = null

    private var location: String? = null

    private var properties: AADProperties? = null

    private var protectedItemName: String? = null

    private var recoveryPointId: String? = null

    private var resourceGroupName: String? = null

    private var tags: Map<String, String>? = null

    private var vaultName: String? = null

    /**
     * @param value Name of the container.
     */
    @JvmName("eswebvutbkefxxbi")
    public suspend fun containerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.containerName = mapped
    }

    /**
     * @param value Optional ETag.
     */
    @JvmName("vcolpcecevhbxeco")
    public suspend fun eTag(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.eTag = mapped
    }

    /**
     * @param value Fabric name associated with the container.
     */
    @JvmName("uyiaefbscxgoufwx")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Resource location.
     */
    @JvmName("bkpoccbvrkqoffee")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.location = mapped
    }

    /**
     * @param value AADPropertiesResource properties
     */
    @JvmName("iaifoumjcbvilllu")
    public suspend fun properties(`value`: AADProperties?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.properties = mapped
    }

    /**
     * @param argument AADPropertiesResource properties
     */
    @JvmName("cflqafyhiuteapfy")
    public suspend fun properties(argument: suspend AADPropertiesBuilder.() -> Unit) {
        val toBeMapped = AADPropertiesBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.properties = mapped
    }

    /**
     * @param value Name of the Protected Item.
     */
    @JvmName("aimmktskyoecmoxi")
    public suspend fun protectedItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectedItemName = mapped
    }

    /**
     * @param value Recovery Point Id
     */
    @JvmName("cwedcibtbcehaess")
    public suspend fun recoveryPointId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.recoveryPointId = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("yktsnjmettnpyyui")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hoeqekdyhsxtuylx")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("jqyxleyoqafqnnhs")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("kxbtnjvvaydkeypt")
    public suspend fun vaultName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vaultName = mapped
    }

    internal fun build(): GetRecoveryPointAccessTokenPlainArgs = GetRecoveryPointAccessTokenPlainArgs(
        containerName = containerName ?: throw PulumiNullFieldException("containerName"),
        eTag = eTag,
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        location = location,
        properties = properties,
        protectedItemName = protectedItemName ?: throw PulumiNullFieldException("protectedItemName"),
        recoveryPointId = recoveryPointId ?: throw PulumiNullFieldException("recoveryPointId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        tags = tags,
        vaultName = vaultName ?: throw PulumiNullFieldException("vaultName"),
    )
}
