@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectedItemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric unique name.
 * @property protectionContainerName Protection container name.
 * @property replicatedProtectedItemName Replication protected item name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationProtectedItemPlainArgs(
    public val fabricName: String,
    public val protectionContainerName: String,
    public val replicatedProtectedItemName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectedItemPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectedItemPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationProtectedItemPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .protectionContainerName(protectionContainerName.let({ args0 -> args0 }))
            .replicatedProtectedItemName(replicatedProtectedItemName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationProtectedItemPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationProtectedItemPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var protectionContainerName: String? = null

    private var replicatedProtectedItemName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Fabric unique name.
     */
    @JvmName("prvhlxnumoqsrexo")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Protection container name.
     */
    @JvmName("lnevyewxowygnctc")
    public suspend fun protectionContainerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.protectionContainerName = mapped
    }

    /**
     * @param value Replication protected item name.
     */
    @JvmName("nxlkesnmjerusdch")
    public suspend fun replicatedProtectedItemName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.replicatedProtectedItemName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("cfdtfaijgyydaaog")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("ugwklysewnhxkbjj")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationProtectedItemPlainArgs = GetReplicationProtectedItemPlainArgs(
        fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
        protectionContainerName = protectionContainerName ?: throw
            PulumiNullFieldException("protectionContainerName"),
        replicatedProtectedItemName = replicatedProtectedItemName ?: throw
            PulumiNullFieldException("replicatedProtectedItemName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
    )
}
