@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryServicesProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property fabricName Fabric name.
 * @property providerName Recovery services provider name.
 * @property resourceGroupName The name of the resource group where the recovery services vault is present.
 * @property resourceName The name of the recovery services vault.
 */
public data class GetReplicationRecoveryServicesProviderPlainArgs(
    public val fabricName: String,
    public val providerName: String,
    public val resourceGroupName: String,
    public val resourceName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryServicesProviderPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryServicesProviderPlainArgs =
        com.pulumi.azurenative.recoveryservices.inputs.GetReplicationRecoveryServicesProviderPlainArgs.builder()
            .fabricName(fabricName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .resourceName(resourceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetReplicationRecoveryServicesProviderPlainArgs].
 */
@PulumiTagMarker
public class GetReplicationRecoveryServicesProviderPlainArgsBuilder internal constructor() {
    private var fabricName: String? = null

    private var providerName: String? = null

    private var resourceGroupName: String? = null

    private var resourceName: String? = null

    /**
     * @param value Fabric name.
     */
    @JvmName("mvhfuvvjaswuuvlm")
    public suspend fun fabricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fabricName = mapped
    }

    /**
     * @param value Recovery services provider name.
     */
    @JvmName("pruwllmjmflcpwta")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    /**
     * @param value The name of the resource group where the recovery services vault is present.
     */
    @JvmName("dosdslomdxpfprlx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the recovery services vault.
     */
    @JvmName("kasqqlkhfcdyorfo")
    public suspend fun resourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceName = mapped
    }

    internal fun build(): GetReplicationRecoveryServicesProviderPlainArgs =
        GetReplicationRecoveryServicesProviderPlainArgs(
            fabricName = fabricName ?: throw PulumiNullFieldException("fabricName"),
            providerName = providerName ?: throw PulumiNullFieldException("providerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            resourceName = resourceName ?: throw PulumiNullFieldException("resourceName"),
        )
}
