@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageDiskExclusionInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * DiskExclusionInput when doing enable protection of virtual machine in InMage provider.
 * @property diskSignatureOptions The guest disk signature based option for disk exclusion.
 * @property volumeOptions The volume label based option for disk exclusion.
 */
public data class InMageDiskExclusionInputArgs(
    public val diskSignatureOptions: Output<List<InMageDiskSignatureExclusionOptionsArgs>>? = null,
    public val volumeOptions: Output<List<InMageVolumeExclusionOptionsArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageDiskExclusionInputArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.InMageDiskExclusionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageDiskExclusionInputArgs.builder()
            .diskSignatureOptions(
                diskSignatureOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .volumeOptions(
                volumeOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [InMageDiskExclusionInputArgs].
 */
@PulumiTagMarker
public class InMageDiskExclusionInputArgsBuilder internal constructor() {
    private var diskSignatureOptions: Output<List<InMageDiskSignatureExclusionOptionsArgs>>? = null

    private var volumeOptions: Output<List<InMageVolumeExclusionOptionsArgs>>? = null

    /**
     * @param value The guest disk signature based option for disk exclusion.
     */
    @JvmName("ksblwqpetecbjjpj")
    public suspend
    fun diskSignatureOptions(`value`: Output<List<InMageDiskSignatureExclusionOptionsArgs>>) {
        this.diskSignatureOptions = value
    }

    @JvmName("ahnjbovuabquehhd")
    public suspend fun diskSignatureOptions(
        vararg
        values: Output<InMageDiskSignatureExclusionOptionsArgs>,
    ) {
        this.diskSignatureOptions = Output.all(values.asList())
    }

    /**
     * @param values The guest disk signature based option for disk exclusion.
     */
    @JvmName("vlwnblrnibervibn")
    public suspend
    fun diskSignatureOptions(values: List<Output<InMageDiskSignatureExclusionOptionsArgs>>) {
        this.diskSignatureOptions = Output.all(values)
    }

    /**
     * @param value The volume label based option for disk exclusion.
     */
    @JvmName("htaahimbgnegreid")
    public suspend fun volumeOptions(`value`: Output<List<InMageVolumeExclusionOptionsArgs>>) {
        this.volumeOptions = value
    }

    @JvmName("utrxigfctfeeumug")
    public suspend fun volumeOptions(vararg values: Output<InMageVolumeExclusionOptionsArgs>) {
        this.volumeOptions = Output.all(values.asList())
    }

    /**
     * @param values The volume label based option for disk exclusion.
     */
    @JvmName("albynkqardalwkaj")
    public suspend fun volumeOptions(values: List<Output<InMageVolumeExclusionOptionsArgs>>) {
        this.volumeOptions = Output.all(values)
    }

    /**
     * @param value The guest disk signature based option for disk exclusion.
     */
    @JvmName("jcundsbbcjaixvxx")
    public suspend fun diskSignatureOptions(`value`: List<InMageDiskSignatureExclusionOptionsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskSignatureOptions = mapped
    }

    /**
     * @param argument The guest disk signature based option for disk exclusion.
     */
    @JvmName("pdnapvyiseaonlur")
    public suspend
    fun diskSignatureOptions(argument: List<suspend InMageDiskSignatureExclusionOptionsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InMageDiskSignatureExclusionOptionsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.diskSignatureOptions = mapped
    }

    /**
     * @param argument The guest disk signature based option for disk exclusion.
     */
    @JvmName("piilcfqsurwohaex")
    public suspend fun diskSignatureOptions(
        vararg
        argument: suspend InMageDiskSignatureExclusionOptionsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InMageDiskSignatureExclusionOptionsArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.diskSignatureOptions = mapped
    }

    /**
     * @param argument The guest disk signature based option for disk exclusion.
     */
    @JvmName("uwmpscaqxlapmqcb")
    public suspend
    fun diskSignatureOptions(argument: suspend InMageDiskSignatureExclusionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InMageDiskSignatureExclusionOptionsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.diskSignatureOptions = mapped
    }

    /**
     * @param values The guest disk signature based option for disk exclusion.
     */
    @JvmName("ttoydgdjmctdnlhq")
    public suspend fun diskSignatureOptions(vararg values: InMageDiskSignatureExclusionOptionsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.diskSignatureOptions = mapped
    }

    /**
     * @param value The volume label based option for disk exclusion.
     */
    @JvmName("jlvjmkofhqdfdvqm")
    public suspend fun volumeOptions(`value`: List<InMageVolumeExclusionOptionsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.volumeOptions = mapped
    }

    /**
     * @param argument The volume label based option for disk exclusion.
     */
    @JvmName("tljndwdlensgvhgu")
    public suspend
    fun volumeOptions(argument: List<suspend InMageVolumeExclusionOptionsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InMageVolumeExclusionOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeOptions = mapped
    }

    /**
     * @param argument The volume label based option for disk exclusion.
     */
    @JvmName("geckjlvtrtthhidp")
    public suspend fun volumeOptions(
        vararg
        argument: suspend InMageVolumeExclusionOptionsArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InMageVolumeExclusionOptionsArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.volumeOptions = mapped
    }

    /**
     * @param argument The volume label based option for disk exclusion.
     */
    @JvmName("nxdtieeobiqknvun")
    public suspend
    fun volumeOptions(argument: suspend InMageVolumeExclusionOptionsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            InMageVolumeExclusionOptionsArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.volumeOptions = mapped
    }

    /**
     * @param values The volume label based option for disk exclusion.
     */
    @JvmName("vrcipyysjqixffyd")
    public suspend fun volumeOptions(vararg values: InMageVolumeExclusionOptionsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.volumeOptions = mapped
    }

    internal fun build(): InMageDiskExclusionInputArgs = InMageDiskExclusionInputArgs(
        diskSignatureOptions = diskSignatureOptions,
        volumeOptions = volumeOptions,
    )
}
