@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageRcmEnableProtectionInputArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.LicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * InMageRcm specific enable protection input.
 * @property disksDefault The default disk input.
 * @property disksToInclude The disks to include list.
 * @property fabricDiscoveryMachineId The ARM Id of discovered machine.
 * @property instanceType The class type.
 * Expected value is 'InMageRcm'.
 * @property licenseType The license type.
 * @property multiVmGroupName The multi VM group name.
 * @property processServerId The process server Id.
 * @property runAsAccountId The run-as account Id.
 * @property targetAvailabilitySetId The target availability set ARM Id.
 * @property targetAvailabilityZone The target availability zone.
 * @property targetBootDiagnosticsStorageAccountId The target boot diagnostics storage account ARM Id.
 * @property targetNetworkId The selected target network ARM Id.
 * @property targetProximityPlacementGroupId The target proximity placement group Id.
 * @property targetResourceGroupId The target resource group ARM Id.
 * @property targetSubnetName The selected target subnet name.
 * @property targetVmName The target VM name.
 * @property targetVmSize The target VM size.
 * @property testNetworkId The selected test network ARM Id.
 * @property testSubnetName The selected test subnet name.
 */
public data class InMageRcmEnableProtectionInputArgs(
    public val disksDefault: Output<InMageRcmDisksDefaultInputArgs>? = null,
    public val disksToInclude: Output<List<InMageRcmDiskInputArgs>>? = null,
    public val fabricDiscoveryMachineId: Output<String>,
    public val instanceType: Output<String>,
    public val licenseType: Output<Either<String, LicenseType>>? = null,
    public val multiVmGroupName: Output<String>? = null,
    public val processServerId: Output<String>,
    public val runAsAccountId: Output<String>? = null,
    public val targetAvailabilitySetId: Output<String>? = null,
    public val targetAvailabilityZone: Output<String>? = null,
    public val targetBootDiagnosticsStorageAccountId: Output<String>? = null,
    public val targetNetworkId: Output<String>? = null,
    public val targetProximityPlacementGroupId: Output<String>? = null,
    public val targetResourceGroupId: Output<String>,
    public val targetSubnetName: Output<String>? = null,
    public val targetVmName: Output<String>? = null,
    public val targetVmSize: Output<String>? = null,
    public val testNetworkId: Output<String>? = null,
    public val testSubnetName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageRcmEnableProtectionInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmEnableProtectionInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmEnableProtectionInputArgs.builder()
            .disksDefault(disksDefault?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .disksToInclude(
                disksToInclude?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .fabricDiscoveryMachineId(fabricDiscoveryMachineId.applyValue({ args0 -> args0 }))
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .multiVmGroupName(multiVmGroupName?.applyValue({ args0 -> args0 }))
            .processServerId(processServerId.applyValue({ args0 -> args0 }))
            .runAsAccountId(runAsAccountId?.applyValue({ args0 -> args0 }))
            .targetAvailabilitySetId(targetAvailabilitySetId?.applyValue({ args0 -> args0 }))
            .targetAvailabilityZone(targetAvailabilityZone?.applyValue({ args0 -> args0 }))
            .targetBootDiagnosticsStorageAccountId(
                targetBootDiagnosticsStorageAccountId?.applyValue({ args0 ->
                    args0
                }),
            )
            .targetNetworkId(targetNetworkId?.applyValue({ args0 -> args0 }))
            .targetProximityPlacementGroupId(targetProximityPlacementGroupId?.applyValue({ args0 -> args0 }))
            .targetResourceGroupId(targetResourceGroupId.applyValue({ args0 -> args0 }))
            .targetSubnetName(targetSubnetName?.applyValue({ args0 -> args0 }))
            .targetVmName(targetVmName?.applyValue({ args0 -> args0 }))
            .targetVmSize(targetVmSize?.applyValue({ args0 -> args0 }))
            .testNetworkId(testNetworkId?.applyValue({ args0 -> args0 }))
            .testSubnetName(testSubnetName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageRcmEnableProtectionInputArgs].
 */
@PulumiTagMarker
public class InMageRcmEnableProtectionInputArgsBuilder internal constructor() {
    private var disksDefault: Output<InMageRcmDisksDefaultInputArgs>? = null

    private var disksToInclude: Output<List<InMageRcmDiskInputArgs>>? = null

    private var fabricDiscoveryMachineId: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var licenseType: Output<Either<String, LicenseType>>? = null

    private var multiVmGroupName: Output<String>? = null

    private var processServerId: Output<String>? = null

    private var runAsAccountId: Output<String>? = null

    private var targetAvailabilitySetId: Output<String>? = null

    private var targetAvailabilityZone: Output<String>? = null

    private var targetBootDiagnosticsStorageAccountId: Output<String>? = null

    private var targetNetworkId: Output<String>? = null

    private var targetProximityPlacementGroupId: Output<String>? = null

    private var targetResourceGroupId: Output<String>? = null

    private var targetSubnetName: Output<String>? = null

    private var targetVmName: Output<String>? = null

    private var targetVmSize: Output<String>? = null

    private var testNetworkId: Output<String>? = null

    private var testSubnetName: Output<String>? = null

    /**
     * @param value The default disk input.
     */
    @JvmName("gfrdcvclevvqwhhm")
    public suspend fun disksDefault(`value`: Output<InMageRcmDisksDefaultInputArgs>) {
        this.disksDefault = value
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("xvijajdaoudiqjcn")
    public suspend fun disksToInclude(`value`: Output<List<InMageRcmDiskInputArgs>>) {
        this.disksToInclude = value
    }

    @JvmName("axrkoaigmkguhbix")
    public suspend fun disksToInclude(vararg values: Output<InMageRcmDiskInputArgs>) {
        this.disksToInclude = Output.all(values.asList())
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("ibsqxwewtsltugpq")
    public suspend fun disksToInclude(values: List<Output<InMageRcmDiskInputArgs>>) {
        this.disksToInclude = Output.all(values)
    }

    /**
     * @param value The ARM Id of discovered machine.
     */
    @JvmName("nwgydmbubxpyevlr")
    public suspend fun fabricDiscoveryMachineId(`value`: Output<String>) {
        this.fabricDiscoveryMachineId = value
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageRcm'.
     */
    @JvmName("gjymttqmbkceuwrs")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The license type.
     */
    @JvmName("hdntalwotceadafe")
    public suspend fun licenseType(`value`: Output<Either<String, LicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("ulihydpsbavhlklv")
    public suspend fun multiVmGroupName(`value`: Output<String>) {
        this.multiVmGroupName = value
    }

    /**
     * @param value The process server Id.
     */
    @JvmName("gwbomotkllukdlnw")
    public suspend fun processServerId(`value`: Output<String>) {
        this.processServerId = value
    }

    /**
     * @param value The run-as account Id.
     */
    @JvmName("siyspmsswuenwdwp")
    public suspend fun runAsAccountId(`value`: Output<String>) {
        this.runAsAccountId = value
    }

    /**
     * @param value The target availability set ARM Id.
     */
    @JvmName("jwqcgttqhgrtavhq")
    public suspend fun targetAvailabilitySetId(`value`: Output<String>) {
        this.targetAvailabilitySetId = value
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("tmhbxstenmwfvdcm")
    public suspend fun targetAvailabilityZone(`value`: Output<String>) {
        this.targetAvailabilityZone = value
    }

    /**
     * @param value The target boot diagnostics storage account ARM Id.
     */
    @JvmName("pnwmqmjrddyccqqp")
    public suspend fun targetBootDiagnosticsStorageAccountId(`value`: Output<String>) {
        this.targetBootDiagnosticsStorageAccountId = value
    }

    /**
     * @param value The selected target network ARM Id.
     */
    @JvmName("lrqogoeeyrljrliu")
    public suspend fun targetNetworkId(`value`: Output<String>) {
        this.targetNetworkId = value
    }

    /**
     * @param value The target proximity placement group Id.
     */
    @JvmName("omtehauooeyunrxi")
    public suspend fun targetProximityPlacementGroupId(`value`: Output<String>) {
        this.targetProximityPlacementGroupId = value
    }

    /**
     * @param value The target resource group ARM Id.
     */
    @JvmName("qhtxjcjwrvrjfpah")
    public suspend fun targetResourceGroupId(`value`: Output<String>) {
        this.targetResourceGroupId = value
    }

    /**
     * @param value The selected target subnet name.
     */
    @JvmName("ionpauerxkebpuoe")
    public suspend fun targetSubnetName(`value`: Output<String>) {
        this.targetSubnetName = value
    }

    /**
     * @param value The target VM name.
     */
    @JvmName("ikglnmoquruujuql")
    public suspend fun targetVmName(`value`: Output<String>) {
        this.targetVmName = value
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("rgcrxqmkuikfdert")
    public suspend fun targetVmSize(`value`: Output<String>) {
        this.targetVmSize = value
    }

    /**
     * @param value The selected test network ARM Id.
     */
    @JvmName("dcdatmyxagclhsdi")
    public suspend fun testNetworkId(`value`: Output<String>) {
        this.testNetworkId = value
    }

    /**
     * @param value The selected test subnet name.
     */
    @JvmName("xejvcmqixhekjcbh")
    public suspend fun testSubnetName(`value`: Output<String>) {
        this.testSubnetName = value
    }

    /**
     * @param value The default disk input.
     */
    @JvmName("bfjsownptcwbbgrf")
    public suspend fun disksDefault(`value`: InMageRcmDisksDefaultInputArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksDefault = mapped
    }

    /**
     * @param argument The default disk input.
     */
    @JvmName("dobkumkcryyrtllv")
    public suspend
    fun disksDefault(argument: suspend InMageRcmDisksDefaultInputArgsBuilder.() -> Unit) {
        val toBeMapped = InMageRcmDisksDefaultInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.disksDefault = mapped
    }

    /**
     * @param value The disks to include list.
     */
    @JvmName("uwbexwvlvjhsfupm")
    public suspend fun disksToInclude(`value`: List<InMageRcmDiskInputArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("vobmnygopncxhbeg")
    public suspend
    fun disksToInclude(argument: List<suspend InMageRcmDiskInputArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InMageRcmDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("csycffrcjoxwrwxl")
    public suspend fun disksToInclude(
        vararg
        argument: suspend InMageRcmDiskInputArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InMageRcmDiskInputArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param argument The disks to include list.
     */
    @JvmName("ftcvypvtprroiayo")
    public suspend fun disksToInclude(argument: suspend InMageRcmDiskInputArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InMageRcmDiskInputArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.disksToInclude = mapped
    }

    /**
     * @param values The disks to include list.
     */
    @JvmName("koajfwbtbxswnfet")
    public suspend fun disksToInclude(vararg values: InMageRcmDiskInputArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.disksToInclude = mapped
    }

    /**
     * @param value The ARM Id of discovered machine.
     */
    @JvmName("npkcqosodhmaggep")
    public suspend fun fabricDiscoveryMachineId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.fabricDiscoveryMachineId = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageRcm'.
     */
    @JvmName("mdlluwjdsrwqfgyr")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("myxqiyjbyosjtanv")
    public suspend fun licenseType(`value`: Either<String, LicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("jpdgmitththxatel")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The license type.
     */
    @JvmName("xldpfpbnmaigsagg")
    public fun licenseType(`value`: LicenseType) {
        val toBeMapped = Either.ofRight<String, LicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value The multi VM group name.
     */
    @JvmName("oasvhdalijsnamfv")
    public suspend fun multiVmGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiVmGroupName = mapped
    }

    /**
     * @param value The process server Id.
     */
    @JvmName("oinwdcajtbyqxrxg")
    public suspend fun processServerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.processServerId = mapped
    }

    /**
     * @param value The run-as account Id.
     */
    @JvmName("btcdwbgvfitikklu")
    public suspend fun runAsAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runAsAccountId = mapped
    }

    /**
     * @param value The target availability set ARM Id.
     */
    @JvmName("qkcivuwlceghasbu")
    public suspend fun targetAvailabilitySetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilitySetId = mapped
    }

    /**
     * @param value The target availability zone.
     */
    @JvmName("vnbphctsttwxvobt")
    public suspend fun targetAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetAvailabilityZone = mapped
    }

    /**
     * @param value The target boot diagnostics storage account ARM Id.
     */
    @JvmName("nltrygfwppnrtxka")
    public suspend fun targetBootDiagnosticsStorageAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetBootDiagnosticsStorageAccountId = mapped
    }

    /**
     * @param value The selected target network ARM Id.
     */
    @JvmName("pvqccfdjdlecwynh")
    public suspend fun targetNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetNetworkId = mapped
    }

    /**
     * @param value The target proximity placement group Id.
     */
    @JvmName("wlkdytjpxookcsut")
    public suspend fun targetProximityPlacementGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetProximityPlacementGroupId = mapped
    }

    /**
     * @param value The target resource group ARM Id.
     */
    @JvmName("cevgownxwhkrgahe")
    public suspend fun targetResourceGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetResourceGroupId = mapped
    }

    /**
     * @param value The selected target subnet name.
     */
    @JvmName("dwflucodflyxagex")
    public suspend fun targetSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSubnetName = mapped
    }

    /**
     * @param value The target VM name.
     */
    @JvmName("plqelcaludwuxkvs")
    public suspend fun targetVmName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmName = mapped
    }

    /**
     * @param value The target VM size.
     */
    @JvmName("tflktlscuxemoepk")
    public suspend fun targetVmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSize = mapped
    }

    /**
     * @param value The selected test network ARM Id.
     */
    @JvmName("vucifcggrnxheilj")
    public suspend fun testNetworkId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testNetworkId = mapped
    }

    /**
     * @param value The selected test subnet name.
     */
    @JvmName("gfishunlgjumgdsm")
    public suspend fun testSubnetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.testSubnetName = mapped
    }

    internal fun build(): InMageRcmEnableProtectionInputArgs = InMageRcmEnableProtectionInputArgs(
        disksDefault = disksDefault,
        disksToInclude = disksToInclude,
        fabricDiscoveryMachineId = fabricDiscoveryMachineId ?: throw
            PulumiNullFieldException("fabricDiscoveryMachineId"),
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        licenseType = licenseType,
        multiVmGroupName = multiVmGroupName,
        processServerId = processServerId ?: throw PulumiNullFieldException("processServerId"),
        runAsAccountId = runAsAccountId,
        targetAvailabilitySetId = targetAvailabilitySetId,
        targetAvailabilityZone = targetAvailabilityZone,
        targetBootDiagnosticsStorageAccountId = targetBootDiagnosticsStorageAccountId,
        targetNetworkId = targetNetworkId,
        targetProximityPlacementGroupId = targetProximityPlacementGroupId,
        targetResourceGroupId = targetResourceGroupId ?: throw
            PulumiNullFieldException("targetResourceGroupId"),
        targetSubnetName = targetSubnetName,
        targetVmName = targetVmName,
        targetVmSize = targetVmSize,
        testNetworkId = testNetworkId,
        testSubnetName = testSubnetName,
    )
}
