@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFabricCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * InMageRcm fabric provider specific settings.
 * @property instanceType Gets the class type.
 * Expected value is 'InMageRcm'.
 * @property physicalSiteId The ARM Id of the physical site.
 * @property sourceAgentIdentity The identity provider input for source agent authentication.
 * @property vmwareSiteId The ARM Id of the VMware site.
 */
public data class InMageRcmFabricCreationInputArgs(
    public val instanceType: Output<String>,
    public val physicalSiteId: Output<String>,
    public val sourceAgentIdentity: Output<IdentityProviderInputArgs>,
    public val vmwareSiteId: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFabricCreationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFabricCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFabricCreationInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .physicalSiteId(physicalSiteId.applyValue({ args0 -> args0 }))
            .sourceAgentIdentity(
                sourceAgentIdentity.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .vmwareSiteId(vmwareSiteId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageRcmFabricCreationInputArgs].
 */
@PulumiTagMarker
public class InMageRcmFabricCreationInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var physicalSiteId: Output<String>? = null

    private var sourceAgentIdentity: Output<IdentityProviderInputArgs>? = null

    private var vmwareSiteId: Output<String>? = null

    /**
     * @param value Gets the class type.
     * Expected value is 'InMageRcm'.
     */
    @JvmName("hecbqgpnhublwjmd")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The ARM Id of the physical site.
     */
    @JvmName("xmcseawwrpeetdve")
    public suspend fun physicalSiteId(`value`: Output<String>) {
        this.physicalSiteId = value
    }

    /**
     * @param value The identity provider input for source agent authentication.
     */
    @JvmName("qhnsvnnnqqlaenwf")
    public suspend fun sourceAgentIdentity(`value`: Output<IdentityProviderInputArgs>) {
        this.sourceAgentIdentity = value
    }

    /**
     * @param value The ARM Id of the VMware site.
     */
    @JvmName("qimiolacgdthxxus")
    public suspend fun vmwareSiteId(`value`: Output<String>) {
        this.vmwareSiteId = value
    }

    /**
     * @param value Gets the class type.
     * Expected value is 'InMageRcm'.
     */
    @JvmName("mgrceoicyapqlwac")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The ARM Id of the physical site.
     */
    @JvmName("gtmycuglidmhqltl")
    public suspend fun physicalSiteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.physicalSiteId = mapped
    }

    /**
     * @param value The identity provider input for source agent authentication.
     */
    @JvmName("khyuyaaoujidndqg")
    public suspend fun sourceAgentIdentity(`value`: IdentityProviderInputArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceAgentIdentity = mapped
    }

    /**
     * @param argument The identity provider input for source agent authentication.
     */
    @JvmName("ltgdpnhmmrhybnkh")
    public suspend
    fun sourceAgentIdentity(argument: suspend IdentityProviderInputArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderInputArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceAgentIdentity = mapped
    }

    /**
     * @param value The ARM Id of the VMware site.
     */
    @JvmName("suconaiaeoudlkdf")
    public suspend fun vmwareSiteId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmwareSiteId = mapped
    }

    internal fun build(): InMageRcmFabricCreationInputArgs = InMageRcmFabricCreationInputArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        physicalSiteId = physicalSiteId ?: throw PulumiNullFieldException("physicalSiteId"),
        sourceAgentIdentity = sourceAgentIdentity ?: throw PulumiNullFieldException("sourceAgentIdentity"),
        vmwareSiteId = vmwareSiteId ?: throw PulumiNullFieldException("vmwareSiteId"),
    )
}
