@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFailbackPolicyCreationInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * InMageRcmFailback policy creation input.
 * @property appConsistentFrequencyInMinutes The app consistent snapshot frequency (in minutes).
 * @property crashConsistentFrequencyInMinutes The crash consistent snapshot frequency (in minutes).
 * @property instanceType The class type.
 * Expected value is 'InMageRcmFailback'.
 */
public data class InMageRcmFailbackPolicyCreationInputArgs(
    public val appConsistentFrequencyInMinutes: Output<Int>? = null,
    public val crashConsistentFrequencyInMinutes: Output<Int>? = null,
    public val instanceType: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFailbackPolicyCreationInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFailbackPolicyCreationInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.InMageRcmFailbackPolicyCreationInputArgs.builder()
            .appConsistentFrequencyInMinutes(appConsistentFrequencyInMinutes?.applyValue({ args0 -> args0 }))
            .crashConsistentFrequencyInMinutes(
                crashConsistentFrequencyInMinutes?.applyValue({ args0 ->
                    args0
                }),
            )
            .instanceType(instanceType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InMageRcmFailbackPolicyCreationInputArgs].
 */
@PulumiTagMarker
public class InMageRcmFailbackPolicyCreationInputArgsBuilder internal constructor() {
    private var appConsistentFrequencyInMinutes: Output<Int>? = null

    private var crashConsistentFrequencyInMinutes: Output<Int>? = null

    private var instanceType: Output<String>? = null

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("jypgqnarvsxbnbir")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.appConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("irsmfoxxsqgijovl")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Output<Int>) {
        this.crashConsistentFrequencyInMinutes = value
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageRcmFailback'.
     */
    @JvmName("klnjiiufhcodgduy")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The app consistent snapshot frequency (in minutes).
     */
    @JvmName("eeoebvgjadigrnvy")
    public suspend fun appConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The crash consistent snapshot frequency (in minutes).
     */
    @JvmName("qrrsasgiaenyshxd")
    public suspend fun crashConsistentFrequencyInMinutes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.crashConsistentFrequencyInMinutes = mapped
    }

    /**
     * @param value The class type.
     * Expected value is 'InMageRcmFailback'.
     */
    @JvmName("xjqrmucidglplfdk")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    internal fun build(): InMageRcmFailbackPolicyCreationInputArgs =
        InMageRcmFailbackPolicyCreationInputArgs(
            appConsistentFrequencyInMinutes = appConsistentFrequencyInMinutes,
            crashConsistentFrequencyInMinutes = crashConsistentFrequencyInMinutes,
            instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        )
}
