@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.KPIResourceHealthDetailsArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.ResourceHealthStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * KPI Resource Health Details
 * @property resourceHealthStatus Resource Health Status
 */
public data class KPIResourceHealthDetailsArgs(
    public val resourceHealthStatus: Output<Either<String, ResourceHealthStatus>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.KPIResourceHealthDetailsArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.KPIResourceHealthDetailsArgs =
        com.pulumi.azurenative.recoveryservices.inputs.KPIResourceHealthDetailsArgs.builder()
            .resourceHealthStatus(
                resourceHealthStatus?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [KPIResourceHealthDetailsArgs].
 */
@PulumiTagMarker
public class KPIResourceHealthDetailsArgsBuilder internal constructor() {
    private var resourceHealthStatus: Output<Either<String, ResourceHealthStatus>>? = null

    /**
     * @param value Resource Health Status
     */
    @JvmName("aloyqrgmrelmkojf")
    public suspend fun resourceHealthStatus(`value`: Output<Either<String, ResourceHealthStatus>>) {
        this.resourceHealthStatus = value
    }

    /**
     * @param value Resource Health Status
     */
    @JvmName("eajptelbuthnguqs")
    public suspend fun resourceHealthStatus(`value`: Either<String, ResourceHealthStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceHealthStatus = mapped
    }

    /**
     * @param value Resource Health Status
     */
    @JvmName("vwnyqvtbxhkeiews")
    public fun resourceHealthStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ResourceHealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceHealthStatus = mapped
    }

    /**
     * @param value Resource Health Status
     */
    @JvmName("hxkrxcujntsntthl")
    public fun resourceHealthStatus(`value`: ResourceHealthStatus) {
        val toBeMapped = Either.ofRight<String, ResourceHealthStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resourceHealthStatus = mapped
    }

    internal fun build(): KPIResourceHealthDetailsArgs = KPIResourceHealthDetailsArgs(
        resourceHealthStatus = resourceHealthStatus,
    )
}
