@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.KeyEncryptionKeyInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Key Encryption Key (KEK) information.
 * @property keyIdentifier The key URL / identifier.
 * @property keyVaultResourceArmId The KeyVault resource ARM Id for key.
 */
public data class KeyEncryptionKeyInfoArgs(
    public val keyIdentifier: Output<String>? = null,
    public val keyVaultResourceArmId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.KeyEncryptionKeyInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.KeyEncryptionKeyInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.KeyEncryptionKeyInfoArgs.builder()
            .keyIdentifier(keyIdentifier?.applyValue({ args0 -> args0 }))
            .keyVaultResourceArmId(keyVaultResourceArmId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyEncryptionKeyInfoArgs].
 */
@PulumiTagMarker
public class KeyEncryptionKeyInfoArgsBuilder internal constructor() {
    private var keyIdentifier: Output<String>? = null

    private var keyVaultResourceArmId: Output<String>? = null

    /**
     * @param value The key URL / identifier.
     */
    @JvmName("tlsbpxchrhwbfceo")
    public suspend fun keyIdentifier(`value`: Output<String>) {
        this.keyIdentifier = value
    }

    /**
     * @param value The KeyVault resource ARM Id for key.
     */
    @JvmName("yrkkxymaidrqgdxc")
    public suspend fun keyVaultResourceArmId(`value`: Output<String>) {
        this.keyVaultResourceArmId = value
    }

    /**
     * @param value The key URL / identifier.
     */
    @JvmName("ahiurfxbratmmlcn")
    public suspend fun keyIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyIdentifier = mapped
    }

    /**
     * @param value The KeyVault resource ARM Id for key.
     */
    @JvmName("foxbkdxoolsejmfc")
    public suspend fun keyVaultResourceArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultResourceArmId = mapped
    }

    internal fun build(): KeyEncryptionKeyInfoArgs = KeyEncryptionKeyInfoArgs(
        keyIdentifier = keyIdentifier,
        keyVaultResourceArmId = keyVaultResourceArmId,
    )
}
