@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.LongTermSchedulePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Long term policy schedule.
 * @property schedulePolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'LongTermSchedulePolicy'.
 */
public data class LongTermSchedulePolicyArgs(
    public val schedulePolicyType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.LongTermSchedulePolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.LongTermSchedulePolicyArgs =
        com.pulumi.azurenative.recoveryservices.inputs.LongTermSchedulePolicyArgs.builder()
            .schedulePolicyType(schedulePolicyType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [LongTermSchedulePolicyArgs].
 */
@PulumiTagMarker
public class LongTermSchedulePolicyArgsBuilder internal constructor() {
    private var schedulePolicyType: Output<String>? = null

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LongTermSchedulePolicy'.
     */
    @JvmName("sxpyywxtxnxbviem")
    public suspend fun schedulePolicyType(`value`: Output<String>) {
        this.schedulePolicyType = value
    }

    /**
     * @param value This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
     * Expected value is 'LongTermSchedulePolicy'.
     */
    @JvmName("mpbuauclxlovfhqa")
    public suspend fun schedulePolicyType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.schedulePolicyType = mapped
    }

    internal fun build(): LongTermSchedulePolicyArgs = LongTermSchedulePolicyArgs(
        schedulePolicyType = schedulePolicyType ?: throw PulumiNullFieldException("schedulePolicyType"),
    )
}
