@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.MabContainerExtendedInfoArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.BackupItemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Additional information of the container.
 * @property backupItemType Type of backup items associated with this container.
 * @property backupItems List of backup items associated with this container.
 * @property lastBackupStatus Latest backup status of this container.
 * @property lastRefreshedAt Time stamp when this container was refreshed.
 * @property policyName Backup policy associated with this container.
 */
public data class MabContainerExtendedInfoArgs(
    public val backupItemType: Output<Either<String, BackupItemType>>? = null,
    public val backupItems: Output<List<String>>? = null,
    public val lastBackupStatus: Output<String>? = null,
    public val lastRefreshedAt: Output<String>? = null,
    public val policyName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.MabContainerExtendedInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.recoveryservices.inputs.MabContainerExtendedInfoArgs =
        com.pulumi.azurenative.recoveryservices.inputs.MabContainerExtendedInfoArgs.builder()
            .backupItemType(
                backupItemType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .backupItems(backupItems?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .lastBackupStatus(lastBackupStatus?.applyValue({ args0 -> args0 }))
            .lastRefreshedAt(lastRefreshedAt?.applyValue({ args0 -> args0 }))
            .policyName(policyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MabContainerExtendedInfoArgs].
 */
@PulumiTagMarker
public class MabContainerExtendedInfoArgsBuilder internal constructor() {
    private var backupItemType: Output<Either<String, BackupItemType>>? = null

    private var backupItems: Output<List<String>>? = null

    private var lastBackupStatus: Output<String>? = null

    private var lastRefreshedAt: Output<String>? = null

    private var policyName: Output<String>? = null

    /**
     * @param value Type of backup items associated with this container.
     */
    @JvmName("efpoajbpbycngehy")
    public suspend fun backupItemType(`value`: Output<Either<String, BackupItemType>>) {
        this.backupItemType = value
    }

    /**
     * @param value List of backup items associated with this container.
     */
    @JvmName("wibbngocrekvosjx")
    public suspend fun backupItems(`value`: Output<List<String>>) {
        this.backupItems = value
    }

    @JvmName("bdbpabxotassbgyp")
    public suspend fun backupItems(vararg values: Output<String>) {
        this.backupItems = Output.all(values.asList())
    }

    /**
     * @param values List of backup items associated with this container.
     */
    @JvmName("avnyvhepnjqfavgd")
    public suspend fun backupItems(values: List<Output<String>>) {
        this.backupItems = Output.all(values)
    }

    /**
     * @param value Latest backup status of this container.
     */
    @JvmName("rgxrcxxvdsemvbcq")
    public suspend fun lastBackupStatus(`value`: Output<String>) {
        this.lastBackupStatus = value
    }

    /**
     * @param value Time stamp when this container was refreshed.
     */
    @JvmName("mkpbwgqifhygavop")
    public suspend fun lastRefreshedAt(`value`: Output<String>) {
        this.lastRefreshedAt = value
    }

    /**
     * @param value Backup policy associated with this container.
     */
    @JvmName("ceepfnejlvcdmwrx")
    public suspend fun policyName(`value`: Output<String>) {
        this.policyName = value
    }

    /**
     * @param value Type of backup items associated with this container.
     */
    @JvmName("iawcrcnvpppjahfk")
    public suspend fun backupItemType(`value`: Either<String, BackupItemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupItemType = mapped
    }

    /**
     * @param value Type of backup items associated with this container.
     */
    @JvmName("srfyeeypwqijhlhp")
    public fun backupItemType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, BackupItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupItemType = mapped
    }

    /**
     * @param value Type of backup items associated with this container.
     */
    @JvmName("brnshimwrfgskdiy")
    public fun backupItemType(`value`: BackupItemType) {
        val toBeMapped = Either.ofRight<String, BackupItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupItemType = mapped
    }

    /**
     * @param value List of backup items associated with this container.
     */
    @JvmName("barahnxhyvumriov")
    public suspend fun backupItems(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupItems = mapped
    }

    /**
     * @param values List of backup items associated with this container.
     */
    @JvmName("pogfqwcsdxtjuysr")
    public suspend fun backupItems(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupItems = mapped
    }

    /**
     * @param value Latest backup status of this container.
     */
    @JvmName("dglewsydnqxfawmg")
    public suspend fun lastBackupStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastBackupStatus = mapped
    }

    /**
     * @param value Time stamp when this container was refreshed.
     */
    @JvmName("drerwpwuofwkqqke")
    public suspend fun lastRefreshedAt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastRefreshedAt = mapped
    }

    /**
     * @param value Backup policy associated with this container.
     */
    @JvmName("bmwljpxnlccerqkm")
    public suspend fun policyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyName = mapped
    }

    internal fun build(): MabContainerExtendedInfoArgs = MabContainerExtendedInfoArgs(
        backupItemType = backupItemType,
        backupItems = backupItems,
        lastBackupStatus = lastBackupStatus,
        lastRefreshedAt = lastRefreshedAt,
        policyName = policyName,
    )
}
