@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.PrivateLinkServiceConnectionStateArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.PrivateEndpointConnectionStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Private Link Service Connection State
 * @property actionsRequired Gets or sets actions required
 * @property description Gets or sets description
 * @property status Gets or sets the status
 */
public data class PrivateLinkServiceConnectionStateArgs(
    public val actionsRequired: Output<String>? = null,
    public val description: Output<String>? = null,
    public val status: Output<Either<String, PrivateEndpointConnectionStatus>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.PrivateLinkServiceConnectionStateArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.PrivateLinkServiceConnectionStateArgs =
        com.pulumi.azurenative.recoveryservices.inputs.PrivateLinkServiceConnectionStateArgs.builder()
            .actionsRequired(actionsRequired?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [PrivateLinkServiceConnectionStateArgs].
 */
@PulumiTagMarker
public class PrivateLinkServiceConnectionStateArgsBuilder internal constructor() {
    private var actionsRequired: Output<String>? = null

    private var description: Output<String>? = null

    private var status: Output<Either<String, PrivateEndpointConnectionStatus>>? = null

    /**
     * @param value Gets or sets actions required
     */
    @JvmName("viahgwnomhljyaoe")
    public suspend fun actionsRequired(`value`: Output<String>) {
        this.actionsRequired = value
    }

    /**
     * @param value Gets or sets description
     */
    @JvmName("wnfecbylffqjliyj")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Gets or sets the status
     */
    @JvmName("dqeyuyixxvrtrikt")
    public suspend fun status(`value`: Output<Either<String, PrivateEndpointConnectionStatus>>) {
        this.status = value
    }

    /**
     * @param value Gets or sets actions required
     */
    @JvmName("rwnktmsmkbfobsny")
    public suspend fun actionsRequired(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionsRequired = mapped
    }

    /**
     * @param value Gets or sets description
     */
    @JvmName("vnveaoxtojkqrvex")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Gets or sets the status
     */
    @JvmName("xmgxqhibtciyquvd")
    public suspend fun status(`value`: Either<String, PrivateEndpointConnectionStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the status
     */
    @JvmName("skrdpgfcnhihshsw")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrivateEndpointConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value Gets or sets the status
     */
    @JvmName("glxbfdeuchtbthux")
    public fun status(`value`: PrivateEndpointConnectionStatus) {
        val toBeMapped = Either.ofRight<String, PrivateEndpointConnectionStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): PrivateLinkServiceConnectionStateArgs =
        PrivateLinkServiceConnectionStateArgs(
            actionsRequired = actionsRequired,
            description = description,
            status = status,
        )
}
