@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.ResourceGuardOperationDetailArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property defaultResourceRequest
 * @property vaultCriticalOperation
 */
public data class ResourceGuardOperationDetailArgs(
    public val defaultResourceRequest: Output<String>? = null,
    public val vaultCriticalOperation: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.ResourceGuardOperationDetailArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.ResourceGuardOperationDetailArgs =
        com.pulumi.azurenative.recoveryservices.inputs.ResourceGuardOperationDetailArgs.builder()
            .defaultResourceRequest(defaultResourceRequest?.applyValue({ args0 -> args0 }))
            .vaultCriticalOperation(vaultCriticalOperation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceGuardOperationDetailArgs].
 */
@PulumiTagMarker
public class ResourceGuardOperationDetailArgsBuilder internal constructor() {
    private var defaultResourceRequest: Output<String>? = null

    private var vaultCriticalOperation: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("kkgrjyjlovelhfly")
    public suspend fun defaultResourceRequest(`value`: Output<String>) {
        this.defaultResourceRequest = value
    }

    /**
     * @param value
     */
    @JvmName("nholphphnwhooyga")
    public suspend fun vaultCriticalOperation(`value`: Output<String>) {
        this.vaultCriticalOperation = value
    }

    /**
     * @param value
     */
    @JvmName("rswhwgnfsbpfyasc")
    public suspend fun defaultResourceRequest(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultResourceRequest = mapped
    }

    /**
     * @param value
     */
    @JvmName("fgmfkyoiehsgcspe")
    public suspend fun vaultCriticalOperation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultCriticalOperation = mapped
    }

    internal fun build(): ResourceGuardOperationDetailArgs = ResourceGuardOperationDetailArgs(
        defaultResourceRequest = defaultResourceRequest,
        vaultCriticalOperation = vaultCriticalOperation,
    )
}
