@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtContainerMappingInputArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMwareCbt container mapping input.
 * @property instanceType The class type.
 * Expected value is 'VMwareCbt'.
 * @property keyVaultId The target key vault ARM Id.
 * @property keyVaultUri The target key vault URL.
 * @property serviceBusConnectionStringSecretName The secret name of the service bus connection string.
 * @property storageAccountId The storage account ARM Id.
 * @property storageAccountSasSecretName The secret name of the storage account.
 * @property targetLocation The target location.
 */
public data class VMwareCbtContainerMappingInputArgs(
    public val instanceType: Output<String>,
    public val keyVaultId: Output<String>? = null,
    public val keyVaultUri: Output<String>? = null,
    public val serviceBusConnectionStringSecretName: Output<String>? = null,
    public val storageAccountId: Output<String>,
    public val storageAccountSasSecretName: Output<String>? = null,
    public val targetLocation: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtContainerMappingInputArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtContainerMappingInputArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtContainerMappingInputArgs.builder()
            .instanceType(instanceType.applyValue({ args0 -> args0 }))
            .keyVaultId(keyVaultId?.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri?.applyValue({ args0 -> args0 }))
            .serviceBusConnectionStringSecretName(
                serviceBusConnectionStringSecretName?.applyValue({ args0 ->
                    args0
                }),
            )
            .storageAccountId(storageAccountId.applyValue({ args0 -> args0 }))
            .storageAccountSasSecretName(storageAccountSasSecretName?.applyValue({ args0 -> args0 }))
            .targetLocation(targetLocation.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VMwareCbtContainerMappingInputArgs].
 */
@PulumiTagMarker
public class VMwareCbtContainerMappingInputArgsBuilder internal constructor() {
    private var instanceType: Output<String>? = null

    private var keyVaultId: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var serviceBusConnectionStringSecretName: Output<String>? = null

    private var storageAccountId: Output<String>? = null

    private var storageAccountSasSecretName: Output<String>? = null

    private var targetLocation: Output<String>? = null

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("kxdhqdbsbooeisnm")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value The target key vault ARM Id.
     */
    @JvmName("iqxsrigbugocxbgs")
    public suspend fun keyVaultId(`value`: Output<String>) {
        this.keyVaultId = value
    }

    /**
     * @param value The target key vault URL.
     */
    @JvmName("knxifnyiqkygjtoi")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value The secret name of the service bus connection string.
     */
    @JvmName("flmufgagdgjxuaey")
    public suspend fun serviceBusConnectionStringSecretName(`value`: Output<String>) {
        this.serviceBusConnectionStringSecretName = value
    }

    /**
     * @param value The storage account ARM Id.
     */
    @JvmName("dereyldtokgsdure")
    public suspend fun storageAccountId(`value`: Output<String>) {
        this.storageAccountId = value
    }

    /**
     * @param value The secret name of the storage account.
     */
    @JvmName("sodwoqlqqvnhrpba")
    public suspend fun storageAccountSasSecretName(`value`: Output<String>) {
        this.storageAccountSasSecretName = value
    }

    /**
     * @param value The target location.
     */
    @JvmName("litoiakkiydxfuvl")
    public suspend fun targetLocation(`value`: Output<String>) {
        this.targetLocation = value
    }

    /**
     * @param value The class type.
     * Expected value is 'VMwareCbt'.
     */
    @JvmName("rchjweublnrcrosh")
    public suspend fun instanceType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value The target key vault ARM Id.
     */
    @JvmName("yhsjrcofogjwlgag")
    public suspend fun keyVaultId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultId = mapped
    }

    /**
     * @param value The target key vault URL.
     */
    @JvmName("dpnkitgxrddvhqgk")
    public suspend fun keyVaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value The secret name of the service bus connection string.
     */
    @JvmName("erbqqlxalehimdba")
    public suspend fun serviceBusConnectionStringSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceBusConnectionStringSecretName = mapped
    }

    /**
     * @param value The storage account ARM Id.
     */
    @JvmName("nxeflxevsiykwnon")
    public suspend fun storageAccountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageAccountId = mapped
    }

    /**
     * @param value The secret name of the storage account.
     */
    @JvmName("koujwlxjibktqhcr")
    public suspend fun storageAccountSasSecretName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageAccountSasSecretName = mapped
    }

    /**
     * @param value The target location.
     */
    @JvmName("kfhvysqdyqhujgwr")
    public suspend fun targetLocation(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetLocation = mapped
    }

    internal fun build(): VMwareCbtContainerMappingInputArgs = VMwareCbtContainerMappingInputArgs(
        instanceType = instanceType ?: throw PulumiNullFieldException("instanceType"),
        keyVaultId = keyVaultId,
        keyVaultUri = keyVaultUri,
        serviceBusConnectionStringSecretName = serviceBusConnectionStringSecretName,
        storageAccountId = storageAccountId ?: throw PulumiNullFieldException("storageAccountId"),
        storageAccountSasSecretName = storageAccountSasSecretName,
        targetLocation = targetLocation ?: throw PulumiNullFieldException("targetLocation"),
    )
}
