@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtSecurityProfilePropertiesArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.SecurityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * VMwareCbt security profile input.
 * @property isTargetVmConfidentialEncryptionEnabled A value indicating whether confidential compute encryption to be enabled.
 * @property isTargetVmIntegrityMonitoringEnabled A value indicating whether integrity monitoring to be enabled.
 * @property isTargetVmSecureBootEnabled A value indicating whether secure boot to be enabled.
 * @property isTargetVmTpmEnabled A value indicating whether trusted platform module to be enabled.
 * @property targetVmSecurityType The target VM security type.
 */
public data class VMwareCbtSecurityProfilePropertiesArgs(
    public val isTargetVmConfidentialEncryptionEnabled: Output<String>? = null,
    public val isTargetVmIntegrityMonitoringEnabled: Output<String>? = null,
    public val isTargetVmSecureBootEnabled: Output<String>? = null,
    public val isTargetVmTpmEnabled: Output<String>? = null,
    public val targetVmSecurityType: Output<Either<String, SecurityType>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtSecurityProfilePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtSecurityProfilePropertiesArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VMwareCbtSecurityProfilePropertiesArgs.builder()
            .isTargetVmConfidentialEncryptionEnabled(
                isTargetVmConfidentialEncryptionEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .isTargetVmIntegrityMonitoringEnabled(
                isTargetVmIntegrityMonitoringEnabled?.applyValue({ args0 ->
                    args0
                }),
            )
            .isTargetVmSecureBootEnabled(isTargetVmSecureBootEnabled?.applyValue({ args0 -> args0 }))
            .isTargetVmTpmEnabled(isTargetVmTpmEnabled?.applyValue({ args0 -> args0 }))
            .targetVmSecurityType(
                targetVmSecurityType?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [VMwareCbtSecurityProfilePropertiesArgs].
 */
@PulumiTagMarker
public class VMwareCbtSecurityProfilePropertiesArgsBuilder internal constructor() {
    private var isTargetVmConfidentialEncryptionEnabled: Output<String>? = null

    private var isTargetVmIntegrityMonitoringEnabled: Output<String>? = null

    private var isTargetVmSecureBootEnabled: Output<String>? = null

    private var isTargetVmTpmEnabled: Output<String>? = null

    private var targetVmSecurityType: Output<Either<String, SecurityType>>? = null

    /**
     * @param value A value indicating whether confidential compute encryption to be enabled.
     */
    @JvmName("ypindyhmquvxewsr")
    public suspend fun isTargetVmConfidentialEncryptionEnabled(`value`: Output<String>) {
        this.isTargetVmConfidentialEncryptionEnabled = value
    }

    /**
     * @param value A value indicating whether integrity monitoring to be enabled.
     */
    @JvmName("idrbbwkeahrvvolp")
    public suspend fun isTargetVmIntegrityMonitoringEnabled(`value`: Output<String>) {
        this.isTargetVmIntegrityMonitoringEnabled = value
    }

    /**
     * @param value A value indicating whether secure boot to be enabled.
     */
    @JvmName("nflegxdncjnhfnon")
    public suspend fun isTargetVmSecureBootEnabled(`value`: Output<String>) {
        this.isTargetVmSecureBootEnabled = value
    }

    /**
     * @param value A value indicating whether trusted platform module to be enabled.
     */
    @JvmName("ttotosswvrghnouh")
    public suspend fun isTargetVmTpmEnabled(`value`: Output<String>) {
        this.isTargetVmTpmEnabled = value
    }

    /**
     * @param value The target VM security type.
     */
    @JvmName("alfnysjvavxjnepv")
    public suspend fun targetVmSecurityType(`value`: Output<Either<String, SecurityType>>) {
        this.targetVmSecurityType = value
    }

    /**
     * @param value A value indicating whether confidential compute encryption to be enabled.
     */
    @JvmName("ewllcwqpggvwnwof")
    public suspend fun isTargetVmConfidentialEncryptionEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTargetVmConfidentialEncryptionEnabled = mapped
    }

    /**
     * @param value A value indicating whether integrity monitoring to be enabled.
     */
    @JvmName("sjtrvxnmjaqekuia")
    public suspend fun isTargetVmIntegrityMonitoringEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTargetVmIntegrityMonitoringEnabled = mapped
    }

    /**
     * @param value A value indicating whether secure boot to be enabled.
     */
    @JvmName("fqkdbqduhrbrgfnb")
    public suspend fun isTargetVmSecureBootEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTargetVmSecureBootEnabled = mapped
    }

    /**
     * @param value A value indicating whether trusted platform module to be enabled.
     */
    @JvmName("kbhvwxshefxadpnt")
    public suspend fun isTargetVmTpmEnabled(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isTargetVmTpmEnabled = mapped
    }

    /**
     * @param value The target VM security type.
     */
    @JvmName("jkecrxfcmbsjemwh")
    public suspend fun targetVmSecurityType(`value`: Either<String, SecurityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetVmSecurityType = mapped
    }

    /**
     * @param value The target VM security type.
     */
    @JvmName("oycpfoxqnnnidmyq")
    public fun targetVmSecurityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVmSecurityType = mapped
    }

    /**
     * @param value The target VM security type.
     */
    @JvmName("snsvwdcldserqieh")
    public fun targetVmSecurityType(`value`: SecurityType) {
        val toBeMapped = Either.ofRight<String, SecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.targetVmSecurityType = mapped
    }

    internal fun build(): VMwareCbtSecurityProfilePropertiesArgs =
        VMwareCbtSecurityProfilePropertiesArgs(
            isTargetVmConfidentialEncryptionEnabled = isTargetVmConfidentialEncryptionEnabled,
            isTargetVmIntegrityMonitoringEnabled = isTargetVmIntegrityMonitoringEnabled,
            isTargetVmSecureBootEnabled = isTargetVmSecureBootEnabled,
            isTargetVmTpmEnabled = isTargetVmTpmEnabled,
            targetVmSecurityType = targetVmSecurityType,
        )
}
