@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.inputs

import com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesEncryptionArgs.builder
import com.pulumi.azurenative.recoveryservices.kotlin.enums.InfrastructureEncryptionState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Customer Managed Key details of the resource.
 * @property infrastructureEncryption Enabling/Disabling the Double Encryption state
 * @property kekIdentity The details of the identity used for CMK
 * @property keyVaultProperties The properties of the Key Vault which hosts CMK
 */
public data class VaultPropertiesEncryptionArgs(
    public val infrastructureEncryption: Output<Either<String, InfrastructureEncryptionState>>? =
        null,
    public val kekIdentity: Output<CmkKekIdentityArgs>? = null,
    public val keyVaultProperties: Output<CmkKeyVaultPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesEncryptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesEncryptionArgs =
        com.pulumi.azurenative.recoveryservices.inputs.VaultPropertiesEncryptionArgs.builder()
            .infrastructureEncryption(
                infrastructureEncryption?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .kekIdentity(kekIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .keyVaultProperties(
                keyVaultProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [VaultPropertiesEncryptionArgs].
 */
@PulumiTagMarker
public class VaultPropertiesEncryptionArgsBuilder internal constructor() {
    private var infrastructureEncryption: Output<Either<String, InfrastructureEncryptionState>>? =
        null

    private var kekIdentity: Output<CmkKekIdentityArgs>? = null

    private var keyVaultProperties: Output<CmkKeyVaultPropertiesArgs>? = null

    /**
     * @param value Enabling/Disabling the Double Encryption state
     */
    @JvmName("grafuprttgkxkmcw")
    public suspend
    fun infrastructureEncryption(`value`: Output<Either<String, InfrastructureEncryptionState>>) {
        this.infrastructureEncryption = value
    }

    /**
     * @param value The details of the identity used for CMK
     */
    @JvmName("loconsstypxmerwn")
    public suspend fun kekIdentity(`value`: Output<CmkKekIdentityArgs>) {
        this.kekIdentity = value
    }

    /**
     * @param value The properties of the Key Vault which hosts CMK
     */
    @JvmName("nhvvjimwmichnllk")
    public suspend fun keyVaultProperties(`value`: Output<CmkKeyVaultPropertiesArgs>) {
        this.keyVaultProperties = value
    }

    /**
     * @param value Enabling/Disabling the Double Encryption state
     */
    @JvmName("hyebxeqquptepaug")
    public suspend
    fun infrastructureEncryption(`value`: Either<String, InfrastructureEncryptionState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.infrastructureEncryption = mapped
    }

    /**
     * @param value Enabling/Disabling the Double Encryption state
     */
    @JvmName("oyqlyxcxtioqdtkp")
    public fun infrastructureEncryption(`value`: String) {
        val toBeMapped = Either.ofLeft<String, InfrastructureEncryptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureEncryption = mapped
    }

    /**
     * @param value Enabling/Disabling the Double Encryption state
     */
    @JvmName("ratpuuopdglfbpgv")
    public fun infrastructureEncryption(`value`: InfrastructureEncryptionState) {
        val toBeMapped = Either.ofRight<String, InfrastructureEncryptionState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.infrastructureEncryption = mapped
    }

    /**
     * @param value The details of the identity used for CMK
     */
    @JvmName("usdsefktnfxpypwr")
    public suspend fun kekIdentity(`value`: CmkKekIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kekIdentity = mapped
    }

    /**
     * @param argument The details of the identity used for CMK
     */
    @JvmName("gyosdxcbnqttmwud")
    public suspend fun kekIdentity(argument: suspend CmkKekIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = CmkKekIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.kekIdentity = mapped
    }

    /**
     * @param value The properties of the Key Vault which hosts CMK
     */
    @JvmName("wfcxvdchuqjgtvvi")
    public suspend fun keyVaultProperties(`value`: CmkKeyVaultPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVaultProperties = mapped
    }

    /**
     * @param argument The properties of the Key Vault which hosts CMK
     */
    @JvmName("oacaxuomdhfscvel")
    public suspend
    fun keyVaultProperties(argument: suspend CmkKeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = CmkKeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.keyVaultProperties = mapped
    }

    internal fun build(): VaultPropertiesEncryptionArgs = VaultPropertiesEncryptionArgs(
        infrastructureEncryption = infrastructureEncryption,
        kekIdentity = kekIdentity,
        keyVaultProperties = keyVaultProperties,
    )
}
