@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Agent details.
 * @property agentId The Id of the agent running on the server.
 * @property biosId The machine BIOS Id.
 * @property disks The disks.
 * @property fqdn The machine FQDN.
 * @property machineId The Id of the machine to which the agent is registered.
 */
public data class AgentDetailsResponse(
    public val agentId: String,
    public val biosId: String,
    public val disks: List<AgentDiskDetailsResponse>,
    public val fqdn: String,
    public val machineId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AgentDetailsResponse):
            AgentDetailsResponse = AgentDetailsResponse(
            agentId = javaType.agentId(),
            biosId = javaType.biosId(),
            disks = javaType.disks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.AgentDiskDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            fqdn = javaType.fqdn(),
            machineId = javaType.machineId(),
        )
    }
}
