@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AzureBackupServer (DPMVenus) workload-specific protection container.
 * @property backupManagementType Type of backup management for the container.
 * @property canReRegister Specifies whether the container is re-registrable.
 * @property containerId ID of container.
 * @property containerType Type of the container. The value of this property for: 1. Compute Azure VM is Microsoft.Compute/virtualMachines 2.
 * Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines 3. Windows machines (like MAB, DPM etc) is
 * Windows 4. Azure SQL instance is AzureSqlContainer. 5. Storage containers is StorageContainer. 6. Azure workload
 * Backup is VMAppContainer
 * Expected value is 'AzureBackupServerContainer'.
 * @property dpmAgentVersion Backup engine Agent version
 * @property dpmServers List of BackupEngines protecting the container
 * @property extendedInfo Extended Info of the container.
 * @property friendlyName Friendly name of the container.
 * @property healthStatus Status of health of the container.
 * @property protectableObjectType Type of the protectable object associated with this container
 * @property protectedItemCount Number of protected items in the BackupEngine
 * @property protectionStatus Protection status of the container.
 * @property registrationStatus Status of registration of the container with the Recovery Services Vault.
 * @property upgradeAvailable To check if upgrade available
 */
public data class AzureBackupServerContainerResponse(
    public val backupManagementType: String? = null,
    public val canReRegister: Boolean? = null,
    public val containerId: String? = null,
    public val containerType: String,
    public val dpmAgentVersion: String? = null,
    public val dpmServers: List<String>? = null,
    public val extendedInfo: DPMContainerExtendedInfoResponse? = null,
    public val friendlyName: String? = null,
    public val healthStatus: String? = null,
    public val protectableObjectType: String? = null,
    public val protectedItemCount: Double? = null,
    public val protectionStatus: String? = null,
    public val registrationStatus: String? = null,
    public val upgradeAvailable: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureBackupServerContainerResponse):
            AzureBackupServerContainerResponse = AzureBackupServerContainerResponse(
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            canReRegister = javaType.canReRegister().map({ args0 -> args0 }).orElse(null),
            containerId = javaType.containerId().map({ args0 -> args0 }).orElse(null),
            containerType = javaType.containerType(),
            dpmAgentVersion = javaType.dpmAgentVersion().map({ args0 -> args0 }).orElse(null),
            dpmServers = javaType.dpmServers().map({ args0 -> args0 }),
            extendedInfo = javaType.extendedInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.DPMContainerExtendedInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            healthStatus = javaType.healthStatus().map({ args0 -> args0 }).orElse(null),
            protectableObjectType = javaType.protectableObjectType().map({ args0 -> args0 }).orElse(null),
            protectedItemCount = javaType.protectedItemCount().map({ args0 -> args0 }).orElse(null),
            protectionStatus = javaType.protectionStatus().map({ args0 -> args0 }).orElse(null),
            registrationStatus = javaType.registrationStatus().map({ args0 -> args0 }).orElse(null),
            upgradeAvailable = javaType.upgradeAvailable().map({ args0 -> args0 }).orElse(null),
        )
    }
}
