@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * AzureStorage backup policy.
 * @property backupManagementType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'AzureStorage'.
 * @property protectedItemsCount Number of items associated with this policy.
 * @property resourceGuardOperationRequests ResourceGuard Operation Requests
 * @property retentionPolicy Retention policy with the details on backup copy retention ranges.
 * @property schedulePolicy Backup schedule specified as part of backup policy.
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 * @property workLoadType Type of workload for the backup management
 */
public data class AzureFileShareProtectionPolicyResponse(
    public val backupManagementType: String,
    public val protectedItemsCount: Int? = null,
    public val resourceGuardOperationRequests: List<String>? = null,
    public val retentionPolicy:
    Either<LongTermRetentionPolicyResponse, SimpleRetentionPolicyResponse>? = null,
    public val schedulePolicy: Any? = null,
    public val timeZone: String? = null,
    public val workLoadType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureFileShareProtectionPolicyResponse):
            AzureFileShareProtectionPolicyResponse = AzureFileShareProtectionPolicyResponse(
            backupManagementType = javaType.backupManagementType(),
            protectedItemsCount = javaType.protectedItemsCount().map({ args0 -> args0 }).orElse(null),
            resourceGuardOperationRequests = javaType.resourceGuardOperationRequests().map({ args0 -> args0 }),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.LongTermRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.recoveryservices.kotlin.outputs.SimpleRetentionPolicyResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            schedulePolicy = javaType.schedulePolicy().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
            workLoadType = javaType.workLoadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
