@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Disk details for E2A provider.
 * @property customTargetDiskName The custom target Azure disk name.
 * @property diskEncryptionSetId The DiskEncryptionSet ARM ID.
 * @property diskId The disk resource id.
 * @property lunId Ordinal\LunId of the disk for the Azure VM.
 * @property maxSizeMB Max side in MB.
 * @property targetDiskLocation Blob uri of the Azure disk.
 * @property targetDiskName The target Azure disk name.
 * @property vhdId The VHD id.
 * @property vhdName VHD name.
 * @property vhdType VHD type.
 */
public data class AzureVmDiskDetailsResponse(
    public val customTargetDiskName: String? = null,
    public val diskEncryptionSetId: String? = null,
    public val diskId: String? = null,
    public val lunId: String? = null,
    public val maxSizeMB: String? = null,
    public val targetDiskLocation: String? = null,
    public val targetDiskName: String? = null,
    public val vhdId: String? = null,
    public val vhdName: String? = null,
    public val vhdType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureVmDiskDetailsResponse):
            AzureVmDiskDetailsResponse = AzureVmDiskDetailsResponse(
            customTargetDiskName = javaType.customTargetDiskName().map({ args0 -> args0 }).orElse(null),
            diskEncryptionSetId = javaType.diskEncryptionSetId().map({ args0 -> args0 }).orElse(null),
            diskId = javaType.diskId().map({ args0 -> args0 }).orElse(null),
            lunId = javaType.lunId().map({ args0 -> args0 }).orElse(null),
            maxSizeMB = javaType.maxSizeMB().map({ args0 -> args0 }).orElse(null),
            targetDiskLocation = javaType.targetDiskLocation().map({ args0 -> args0 }).orElse(null),
            targetDiskName = javaType.targetDiskName().map({ args0 -> args0 }).orElse(null),
            vhdId = javaType.vhdId().map({ args0 -> args0 }).orElse(null),
            vhdName = javaType.vhdName().map({ args0 -> args0 }).orElse(null),
            vhdType = javaType.vhdType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
