@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Azure Workload SQL Auto Protection intent item.
 * @property backupManagementType Type of backup management for the backed up item.
 * @property itemId ID of the item which is getting protected, In case of Azure Vm , it is ProtectedItemId
 * @property policyId ID of the backup policy with which this item is backed up.
 * @property protectionIntentItemType backup protectionIntent type.
 * Expected value is 'AzureWorkloadSQLAutoProtectionIntent'.
 * @property protectionState Backup state of this backup item.
 * @property sourceResourceId ARM ID of the resource to be backed up.
 * @property workloadItemType Workload item type of the item for which intent is to be set
 */
public data class AzureWorkloadSQLAutoProtectionIntentResponse(
    public val backupManagementType: String? = null,
    public val itemId: String? = null,
    public val policyId: String? = null,
    public val protectionIntentItemType: String,
    public val protectionState: String? = null,
    public val sourceResourceId: String? = null,
    public val workloadItemType: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.AzureWorkloadSQLAutoProtectionIntentResponse):
            AzureWorkloadSQLAutoProtectionIntentResponse = AzureWorkloadSQLAutoProtectionIntentResponse(
            backupManagementType = javaType.backupManagementType().map({ args0 -> args0 }).orElse(null),
            itemId = javaType.itemId().map({ args0 -> args0 }).orElse(null),
            policyId = javaType.policyId().map({ args0 -> args0 }).orElse(null),
            protectionIntentItemType = javaType.protectionIntentItemType(),
            protectionState = javaType.protectionState().map({ args0 -> args0 }).orElse(null),
            sourceResourceId = javaType.sourceResourceId().map({ args0 -> args0 }).orElse(null),
            workloadItemType = javaType.workloadItemType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
