@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Current job details of the migration item.
 * @property jobId The ARM Id of the job being executed.
 * @property jobName The job name.
 * @property startTime The start time of the job.
 */
public data class CurrentJobDetailsResponse(
    public val jobId: String,
    public val jobName: String,
    public val startTime: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.CurrentJobDetailsResponse):
            CurrentJobDetailsResponse = CurrentJobDetailsResponse(
            jobId = javaType.jobId(),
            jobName = javaType.jobName(),
            startTime = javaType.startTime(),
        )
    }
}
