@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property diskLunList List of Disks' Logical Unit Numbers (LUN) to be used for VM Protection.
 * @property isInclusionList Flag to indicate whether DiskLunList is to be included/ excluded from backup.
 */
public data class DiskExclusionPropertiesResponse(
    public val diskLunList: List<Int>? = null,
    public val isInclusionList: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.DiskExclusionPropertiesResponse):
            DiskExclusionPropertiesResponse = DiskExclusionPropertiesResponse(
            diskLunList = javaType.diskLunList().map({ args0 -> args0 }),
            isInclusionList = javaType.isInclusionList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
