@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Extended location of the resource.
 * @property name The name of the extended location.
 * @property type The extended location type.
 */
public data class ExtendedLocationResponse(
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ExtendedLocationResponse):
            ExtendedLocationResponse = ExtendedLocationResponse(
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
