@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Container extended information
 * @property containerIdentityInfo Container identity information
 * @property rawCertData Public key of container cert
 * @property serviceEndpoints Azure Backup Service Endpoints for the container
 */
public data class GenericContainerExtendedInfoResponse(
    public val containerIdentityInfo: ContainerIdentityInfoResponse? = null,
    public val rawCertData: String? = null,
    public val serviceEndpoints: Map<String, String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.GenericContainerExtendedInfoResponse):
            GenericContainerExtendedInfoResponse = GenericContainerExtendedInfoResponse(
            containerIdentityInfo = javaType.containerIdentityInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ContainerIdentityInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            rawCertData = javaType.rawCertData().map({ args0 -> args0 }).orElse(null),
            serviceEndpoints = javaType.serviceEndpoints().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
