@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the InMage agent.
 * @property agentExpiryDate Agent expiry date.
 * @property agentUpdateStatus A value indicating whether installed agent needs to be updated.
 * @property agentVersion The agent version.
 * @property postUpdateRebootStatus A value indicating whether reboot is required after update is applied.
 */
public data class InMageAgentDetailsResponse(
    public val agentExpiryDate: String? = null,
    public val agentUpdateStatus: String? = null,
    public val agentVersion: String? = null,
    public val postUpdateRebootStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.InMageAgentDetailsResponse):
            InMageAgentDetailsResponse = InMageAgentDetailsResponse(
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentUpdateStatus = javaType.agentUpdateStatus().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            postUpdateRebootStatus = javaType.postUpdateRebootStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
