@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Process server details.
 * @property availableMemoryInBytes The available memory.
 * @property availableSpaceInBytes The available disk space.
 * @property biosId The process server Bios Id.
 * @property diskUsageStatus The disk usage status.
 * @property fabricObjectId The fabric object Id.
 * @property fqdn The process server Fqdn.
 * @property freeSpacePercentage The free disk space percentage.
 * @property health The health of the process server.
 * @property healthErrors The health errors.
 * @property historicHealth The historic health of the process server based on the health in last 24 hours.
 * @property id The process server Id.
 * @property ipAddresses The list of IP addresses for communicating with the RCM component.
 * @property lastHeartbeatUtc The last heartbeat received from the process server.
 * @property memoryUsagePercentage The memory usage percentage.
 * @property memoryUsageStatus The memory usage status.
 * @property name The process server name.
 * @property processorUsagePercentage The processor usage percentage.
 * @property processorUsageStatus The processor usage status.
 * @property protectedItemCount The protected item count.
 * @property systemLoad The system load.
 * @property systemLoadStatus The system load status.
 * @property throughputInBytes The throughput in bytes.
 * @property throughputStatus The throughput status.
 * @property throughputUploadPendingDataInBytes The uploading pending data in bytes.
 * @property totalMemoryInBytes The total memory.
 * @property totalSpaceInBytes The total disk space.
 * @property usedMemoryInBytes The used memory.
 * @property usedSpaceInBytes The used disk space.
 * @property version The version.
 */
public data class ProcessServerDetailsResponse(
    public val availableMemoryInBytes: Double,
    public val availableSpaceInBytes: Double,
    public val biosId: String,
    public val diskUsageStatus: String,
    public val fabricObjectId: String,
    public val fqdn: String,
    public val freeSpacePercentage: Double,
    public val health: String,
    public val healthErrors: List<HealthErrorResponse>,
    public val historicHealth: String,
    public val id: String,
    public val ipAddresses: List<String>,
    public val lastHeartbeatUtc: String,
    public val memoryUsagePercentage: Double,
    public val memoryUsageStatus: String,
    public val name: String,
    public val processorUsagePercentage: Double,
    public val processorUsageStatus: String,
    public val protectedItemCount: Int,
    public val systemLoad: Double,
    public val systemLoadStatus: String,
    public val throughputInBytes: Double,
    public val throughputStatus: String,
    public val throughputUploadPendingDataInBytes: Double,
    public val totalMemoryInBytes: Double,
    public val totalSpaceInBytes: Double,
    public val usedMemoryInBytes: Double,
    public val usedSpaceInBytes: Double,
    public val version: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.ProcessServerDetailsResponse):
            ProcessServerDetailsResponse = ProcessServerDetailsResponse(
            availableMemoryInBytes = javaType.availableMemoryInBytes(),
            availableSpaceInBytes = javaType.availableSpaceInBytes(),
            biosId = javaType.biosId(),
            diskUsageStatus = javaType.diskUsageStatus(),
            fabricObjectId = javaType.fabricObjectId(),
            fqdn = javaType.fqdn(),
            freeSpacePercentage = javaType.freeSpacePercentage(),
            health = javaType.health(),
            healthErrors = javaType.healthErrors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.HealthErrorResponse.Companion.toKotlin(args0)
                })
            }),
            historicHealth = javaType.historicHealth(),
            id = javaType.id(),
            ipAddresses = javaType.ipAddresses().map({ args0 -> args0 }),
            lastHeartbeatUtc = javaType.lastHeartbeatUtc(),
            memoryUsagePercentage = javaType.memoryUsagePercentage(),
            memoryUsageStatus = javaType.memoryUsageStatus(),
            name = javaType.name(),
            processorUsagePercentage = javaType.processorUsagePercentage(),
            processorUsageStatus = javaType.processorUsageStatus(),
            protectedItemCount = javaType.protectedItemCount(),
            systemLoad = javaType.systemLoad(),
            systemLoadStatus = javaType.systemLoadStatus(),
            throughputInBytes = javaType.throughputInBytes(),
            throughputStatus = javaType.throughputStatus(),
            throughputUploadPendingDataInBytes = javaType.throughputUploadPendingDataInBytes(),
            totalMemoryInBytes = javaType.totalMemoryInBytes(),
            totalSpaceInBytes = javaType.totalSpaceInBytes(),
            usedMemoryInBytes = javaType.usedMemoryInBytes(),
            usedSpaceInBytes = javaType.usedSpaceInBytes(),
            version = javaType.version(),
        )
    }
}
