@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Recovery plan protected item.
 * @property id The ARM Id of the recovery plan protected item.
 * @property virtualMachineId The virtual machine Id.
 */
public data class RecoveryPlanProtectedItemResponse(
    public val id: String? = null,
    public val virtualMachineId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.RecoveryPlanProtectedItemResponse):
            RecoveryPlanProtectedItemResponse = RecoveryPlanProtectedItemResponse(
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            virtualMachineId = javaType.virtualMachineId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
