@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Simple policy retention.
 * @property retentionDuration Retention duration of the protection policy.
 * @property retentionPolicyType This property will be used as the discriminator for deciding the specific types in the polymorphic chain of types.
 * Expected value is 'SimpleRetentionPolicy'.
 */
public data class SimpleRetentionPolicyResponse(
    public val retentionDuration: RetentionDurationResponse? = null,
    public val retentionPolicyType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.SimpleRetentionPolicyResponse):
            SimpleRetentionPolicyResponse = SimpleRetentionPolicyResponse(
            retentionDuration = javaType.retentionDuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RetentionDurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            retentionPolicyType = javaType.retentionPolicyType(),
        )
    }
}
