@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Store the fabric details specific to the VMware fabric.
 * @property agentCount The number of source and target servers configured to talk to this CS.
 * @property agentExpiryDate Agent expiry date.
 * @property agentVersion The agent Version.
 * @property agentVersionDetails The agent version details.
 * @property availableMemoryInBytes The available memory.
 * @property availableSpaceInBytes The available space.
 * @property cpuLoad The percentage of the CPU load.
 * @property cpuLoadStatus The CPU load status.
 * @property csServiceStatus The CS service status.
 * @property databaseServerLoad The database server load.
 * @property databaseServerLoadStatus The database server load status.
 * @property hostName The host name.
 * @property instanceType Gets the class type. Overridden in derived classes.
 * Expected value is 'VMware'.
 * @property ipAddress The IP address.
 * @property lastHeartbeat The last heartbeat received from CS server.
 * @property masterTargetServers The list of Master Target servers associated with the fabric.
 * @property memoryUsageStatus The memory usage status.
 * @property processServerCount The number of process servers.
 * @property processServers The list of Process Servers associated with the fabric.
 * @property protectedServers The number of protected servers.
 * @property psTemplateVersion PS template version.
 * @property replicationPairCount The number of replication pairs configured in this CS.
 * @property runAsAccounts The list of run as accounts created on the server.
 * @property spaceUsageStatus The space usage status.
 * @property sslCertExpiryDate CS SSL cert expiry date.
 * @property sslCertExpiryRemainingDays CS SSL cert expiry date.
 * @property switchProviderBlockingErrorDetails The switch provider blocking error information.
 * @property systemLoad The percentage of the system load.
 * @property systemLoadStatus The system load status.
 * @property totalMemoryInBytes The total memory.
 * @property totalSpaceInBytes The total space.
 * @property versionStatus Version status.
 * @property webLoad The web load.
 * @property webLoadStatus The web load status.
 */
public data class VMwareDetailsResponse(
    public val agentCount: String? = null,
    public val agentExpiryDate: String? = null,
    public val agentVersion: String? = null,
    public val agentVersionDetails: VersionDetailsResponse? = null,
    public val availableMemoryInBytes: Double? = null,
    public val availableSpaceInBytes: Double? = null,
    public val cpuLoad: String? = null,
    public val cpuLoadStatus: String? = null,
    public val csServiceStatus: String? = null,
    public val databaseServerLoad: String? = null,
    public val databaseServerLoadStatus: String? = null,
    public val hostName: String? = null,
    public val instanceType: String,
    public val ipAddress: String? = null,
    public val lastHeartbeat: String? = null,
    public val masterTargetServers: List<MasterTargetServerResponse>? = null,
    public val memoryUsageStatus: String? = null,
    public val processServerCount: String? = null,
    public val processServers: List<ProcessServerResponse>? = null,
    public val protectedServers: String? = null,
    public val psTemplateVersion: String? = null,
    public val replicationPairCount: String? = null,
    public val runAsAccounts: List<RunAsAccountResponse>? = null,
    public val spaceUsageStatus: String? = null,
    public val sslCertExpiryDate: String? = null,
    public val sslCertExpiryRemainingDays: Int? = null,
    public val switchProviderBlockingErrorDetails:
    List<InMageFabricSwitchProviderBlockingErrorDetailsResponse>? = null,
    public val systemLoad: String? = null,
    public val systemLoadStatus: String? = null,
    public val totalMemoryInBytes: Double? = null,
    public val totalSpaceInBytes: Double? = null,
    public val versionStatus: String? = null,
    public val webLoad: String? = null,
    public val webLoadStatus: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VMwareDetailsResponse):
            VMwareDetailsResponse = VMwareDetailsResponse(
            agentCount = javaType.agentCount().map({ args0 -> args0 }).orElse(null),
            agentExpiryDate = javaType.agentExpiryDate().map({ args0 -> args0 }).orElse(null),
            agentVersion = javaType.agentVersion().map({ args0 -> args0 }).orElse(null),
            agentVersionDetails = javaType.agentVersionDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.VersionDetailsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            availableMemoryInBytes = javaType.availableMemoryInBytes().map({ args0 -> args0 }).orElse(null),
            availableSpaceInBytes = javaType.availableSpaceInBytes().map({ args0 -> args0 }).orElse(null),
            cpuLoad = javaType.cpuLoad().map({ args0 -> args0 }).orElse(null),
            cpuLoadStatus = javaType.cpuLoadStatus().map({ args0 -> args0 }).orElse(null),
            csServiceStatus = javaType.csServiceStatus().map({ args0 -> args0 }).orElse(null),
            databaseServerLoad = javaType.databaseServerLoad().map({ args0 -> args0 }).orElse(null),
            databaseServerLoadStatus = javaType.databaseServerLoadStatus().map({ args0 -> args0 }).orElse(null),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            instanceType = javaType.instanceType(),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            lastHeartbeat = javaType.lastHeartbeat().map({ args0 -> args0 }).orElse(null),
            masterTargetServers = javaType.masterTargetServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.MasterTargetServerResponse.Companion.toKotlin(args0)
                })
            }),
            memoryUsageStatus = javaType.memoryUsageStatus().map({ args0 -> args0 }).orElse(null),
            processServerCount = javaType.processServerCount().map({ args0 -> args0 }).orElse(null),
            processServers = javaType.processServers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.ProcessServerResponse.Companion.toKotlin(args0)
                })
            }),
            protectedServers = javaType.protectedServers().map({ args0 -> args0 }).orElse(null),
            psTemplateVersion = javaType.psTemplateVersion().map({ args0 -> args0 }).orElse(null),
            replicationPairCount = javaType.replicationPairCount().map({ args0 -> args0 }).orElse(null),
            runAsAccounts = javaType.runAsAccounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.RunAsAccountResponse.Companion.toKotlin(args0)
                })
            }),
            spaceUsageStatus = javaType.spaceUsageStatus().map({ args0 -> args0 }).orElse(null),
            sslCertExpiryDate = javaType.sslCertExpiryDate().map({ args0 -> args0 }).orElse(null),
            sslCertExpiryRemainingDays = javaType.sslCertExpiryRemainingDays().map({ args0 ->
                args0
            }).orElse(null),
            switchProviderBlockingErrorDetails = javaType.switchProviderBlockingErrorDetails().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.recoveryservices.kotlin.outputs.InMageFabricSwitchProviderBlockingErrorDetailsResponse.Companion.toKotlin(args0)
                })
            }),
            systemLoad = javaType.systemLoad().map({ args0 -> args0 }).orElse(null),
            systemLoadStatus = javaType.systemLoadStatus().map({ args0 -> args0 }).orElse(null),
            totalMemoryInBytes = javaType.totalMemoryInBytes().map({ args0 -> args0 }).orElse(null),
            totalSpaceInBytes = javaType.totalSpaceInBytes().map({ args0 -> args0 }).orElse(null),
            versionStatus = javaType.versionStatus().map({ args0 -> args0 }).orElse(null),
            webLoad = javaType.webLoad().map({ args0 -> args0 }).orElse(null),
            webLoadStatus = javaType.webLoadStatus().map({ args0 -> args0 }).orElse(null),
        )
    }
}
