@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.recoveryservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The details of the latest move operation performed on the Azure Resource
 * @property completionTimeUtc End Time of the Resource Move Operation
 * @property operationId OperationId of the Resource Move Operation
 * @property sourceResourceId Source Resource of the Resource Move Operation
 * @property startTimeUtc Start Time of the Resource Move Operation
 * @property targetResourceId Target Resource of the Resource Move Operation
 */
public data class VaultPropertiesResponseMoveDetails(
    public val completionTimeUtc: String,
    public val operationId: String,
    public val sourceResourceId: String,
    public val startTimeUtc: String,
    public val targetResourceId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.recoveryservices.outputs.VaultPropertiesResponseMoveDetails):
            VaultPropertiesResponseMoveDetails = VaultPropertiesResponseMoveDetails(
            completionTimeUtc = javaType.completionTimeUtc(),
            operationId = javaType.operationId(),
            sourceResourceId = javaType.sourceResourceId(),
            startTimeUtc = javaType.startTimeUtc(),
            targetResourceId = javaType.targetResourceId(),
        )
    }
}
