@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.inputs

import com.pulumi.azurenative.redhatopenshift.inputs.MasterProfileArgs.builder
import com.pulumi.azurenative.redhatopenshift.kotlin.enums.EncryptionAtHost
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * MasterProfile represents a master profile.
 * @property diskEncryptionSetId The resource ID of an associated DiskEncryptionSet, if applicable.
 * @property encryptionAtHost Whether master virtual machines are encrypted at host.
 * @property subnetId The Azure resource ID of the master subnet.
 * @property vmSize The size of the master VMs.
 */
public data class MasterProfileArgs(
    public val diskEncryptionSetId: Output<String>? = null,
    public val encryptionAtHost: Output<Either<String, EncryptionAtHost>>? = null,
    public val subnetId: Output<String>? = null,
    public val vmSize: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.redhatopenshift.inputs.MasterProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.redhatopenshift.inputs.MasterProfileArgs =
        com.pulumi.azurenative.redhatopenshift.inputs.MasterProfileArgs.builder()
            .diskEncryptionSetId(diskEncryptionSetId?.applyValue({ args0 -> args0 }))
            .encryptionAtHost(
                encryptionAtHost?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MasterProfileArgs].
 */
@PulumiTagMarker
public class MasterProfileArgsBuilder internal constructor() {
    private var diskEncryptionSetId: Output<String>? = null

    private var encryptionAtHost: Output<Either<String, EncryptionAtHost>>? = null

    private var subnetId: Output<String>? = null

    private var vmSize: Output<String>? = null

    /**
     * @param value The resource ID of an associated DiskEncryptionSet, if applicable.
     */
    @JvmName("ifyjcboaxdycoavu")
    public suspend fun diskEncryptionSetId(`value`: Output<String>) {
        this.diskEncryptionSetId = value
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("qdxgcuqmsfbaojka")
    public suspend fun encryptionAtHost(`value`: Output<Either<String, EncryptionAtHost>>) {
        this.encryptionAtHost = value
    }

    /**
     * @param value The Azure resource ID of the master subnet.
     */
    @JvmName("qurgrkxqwmmuvhpd")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value The size of the master VMs.
     */
    @JvmName("macgplgtlxpvacrk")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The resource ID of an associated DiskEncryptionSet, if applicable.
     */
    @JvmName("lelrvguumfaogjwa")
    public suspend fun diskEncryptionSetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskEncryptionSetId = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("omwwsyvgthncnlqq")
    public suspend fun encryptionAtHost(`value`: Either<String, EncryptionAtHost>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("urjaxaqqpxcrnsgb")
    public fun encryptionAtHost(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EncryptionAtHost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Whether master virtual machines are encrypted at host.
     */
    @JvmName("jyncolomupiwumjr")
    public fun encryptionAtHost(`value`: EncryptionAtHost) {
        val toBeMapped = Either.ofRight<String, EncryptionAtHost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value The Azure resource ID of the master subnet.
     */
    @JvmName("rytgdgeldrynmwif")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value The size of the master VMs.
     */
    @JvmName("gpbswlcgixoqolxm")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): MasterProfileArgs = MasterProfileArgs(
        diskEncryptionSetId = diskEncryptionSetId,
        encryptionAtHost = encryptionAtHost,
        subnetId = subnetId,
        vmSize = vmSize,
    )
}
