@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.redhatopenshift.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * ClusterProfile represents a cluster profile.
 * @property domain The domain for the cluster.
 * @property fipsValidatedModules If FIPS validated crypto modules are used
 * @property pullSecret The pull secret for the cluster.
 * @property resourceGroupId The ID of the cluster resource group.
 * @property version The version of the cluster.
 */
public data class ClusterProfileResponse(
    public val domain: String? = null,
    public val fipsValidatedModules: String? = null,
    public val pullSecret: String? = null,
    public val resourceGroupId: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.redhatopenshift.outputs.ClusterProfileResponse):
            ClusterProfileResponse = ClusterProfileResponse(
            domain = javaType.domain().map({ args0 -> args0 }).orElse(null),
            fipsValidatedModules = javaType.fipsValidatedModules().map({ args0 -> args0 }).orElse(null),
            pullSecret = javaType.pullSecret().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
