@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.inputs

import com.pulumi.azurenative.relay.inputs.GetHybridConnectionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property hybridConnectionName The hybrid connection name.
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetHybridConnectionPlainArgs(
    public val hybridConnectionName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.relay.inputs.GetHybridConnectionPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.inputs.GetHybridConnectionPlainArgs =
        com.pulumi.azurenative.relay.inputs.GetHybridConnectionPlainArgs.builder()
            .hybridConnectionName(hybridConnectionName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridConnectionPlainArgs].
 */
@PulumiTagMarker
public class GetHybridConnectionPlainArgsBuilder internal constructor() {
    private var hybridConnectionName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The hybrid connection name.
     */
    @JvmName("lscediioxvxurghx")
    public suspend fun hybridConnectionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.hybridConnectionName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wysqayhsmjbqojvl")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("vradgwcrllafqktc")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetHybridConnectionPlainArgs = GetHybridConnectionPlainArgs(
        hybridConnectionName = hybridConnectionName ?: throw
            PulumiNullFieldException("hybridConnectionName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
