@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.inputs

import com.pulumi.azurenative.relay.inputs.GetWCFRelayAuthorizationRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property relayName The relay name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetWCFRelayAuthorizationRulePlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val relayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.relay.inputs.GetWCFRelayAuthorizationRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.inputs.GetWCFRelayAuthorizationRulePlainArgs =
        com.pulumi.azurenative.relay.inputs.GetWCFRelayAuthorizationRulePlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .relayName(relayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetWCFRelayAuthorizationRulePlainArgs].
 */
@PulumiTagMarker
public class GetWCFRelayAuthorizationRulePlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var relayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("iakkfbccslpvaqjj")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("oheghgqpcgtsqoke")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name.
     */
    @JvmName("orhvtctwjbqeqhla")
    public suspend fun relayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relayName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jlqvfjjijkixvqgp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetWCFRelayAuthorizationRulePlainArgs =
        GetWCFRelayAuthorizationRulePlainArgs(
            authorizationRuleName = authorizationRuleName ?: throw
                PulumiNullFieldException("authorizationRuleName"),
            namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
            relayName = relayName ?: throw PulumiNullFieldException("relayName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
