@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.relay.kotlin.inputs

import com.pulumi.azurenative.relay.inputs.ListWCFRelayKeysPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authorizationRuleName The authorization rule name.
 * @property namespaceName The namespace name
 * @property relayName The relay name.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class ListWCFRelayKeysPlainArgs(
    public val authorizationRuleName: String,
    public val namespaceName: String,
    public val relayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.relay.inputs.ListWCFRelayKeysPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.relay.inputs.ListWCFRelayKeysPlainArgs =
        com.pulumi.azurenative.relay.inputs.ListWCFRelayKeysPlainArgs.builder()
            .authorizationRuleName(authorizationRuleName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .relayName(relayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [ListWCFRelayKeysPlainArgs].
 */
@PulumiTagMarker
public class ListWCFRelayKeysPlainArgsBuilder internal constructor() {
    private var authorizationRuleName: String? = null

    private var namespaceName: String? = null

    private var relayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The authorization rule name.
     */
    @JvmName("qyvxipwraismwcdr")
    public suspend fun authorizationRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.authorizationRuleName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("qistrvlrrdmajaix")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value The relay name.
     */
    @JvmName("ocwrjjyjttneofxc")
    public suspend fun relayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relayName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("wjncapgrfxgcphhl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): ListWCFRelayKeysPlainArgs = ListWCFRelayKeysPlainArgs(
        authorizationRuleName = authorizationRuleName ?: throw
            PulumiNullFieldException("authorizationRuleName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        relayName = relayName ?: throw PulumiNullFieldException("relayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
