@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourceconnector.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The List Cluster User Credential appliance.
 * @property hybridConnectionConfig Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).
 * @property kubeconfigs The list of appliance kubeconfigs.
 */
public data class ListApplianceClusterUserCredentialResult(
    public val hybridConnectionConfig: HybridConnectionConfigResponse,
    public val kubeconfigs: List<ApplianceCredentialKubeconfigResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.resourceconnector.outputs.ListApplianceClusterUserCredentialResult):
            ListApplianceClusterUserCredentialResult = ListApplianceClusterUserCredentialResult(
            hybridConnectionConfig = javaType.hybridConnectionConfig().let({ args0 ->
                com.pulumi.azurenative.resourceconnector.kotlin.outputs.HybridConnectionConfigResponse.Companion.toKotlin(args0)
            }),
            kubeconfigs = javaType.kubeconfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.resourceconnector.kotlin.outputs.ApplianceCredentialKubeconfigResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
