@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resourcegraph.kotlin

import com.pulumi.azurenative.resourcegraph.GraphQueryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Graph Query entity definition.
 * Azure REST API version: 2020-04-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create Graph Query
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var graphQuery = new AzureNative.ResourceGraph.GraphQuery("graphQuery", new()
 *     {
 *         Description = "Docker VMs in PROD",
 *         Query = "where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'",
 *         ResourceGroupName = "my-resource-group",
 *         ResourceName = "MyDockerVMs",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resourcegraph/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resourcegraph.NewGraphQuery(ctx, "graphQuery", &resourcegraph.GraphQueryArgs{
 * 			Description:       pulumi.String("Docker VMs in PROD"),
 * 			Query:             pulumi.String("where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 			ResourceName:      pulumi.String("MyDockerVMs"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resourcegraph.GraphQuery;
 * import com.pulumi.azurenative.resourcegraph.GraphQueryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var graphQuery = new GraphQuery("graphQuery", GraphQueryArgs.builder()
 *             .description("Docker VMs in PROD")
 *             .query("where isnotnull(tags['Prod']) and properties.extensions[0].Name == 'docker'")
 *             .resourceGroupName("my-resource-group")
 *             .resourceName("MyDockerVMs")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resourcegraph:GraphQuery MyDockerVMs /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ResourceGraph/queries/{resourceName}
 * ```
 * @property description The description of a graph query.
 * @property query KQL query that will be graph.
 * @property resourceGroupName The name of the resource group.
 * @property resourceName The name of the Graph Query resource.
 * @property tags Resource tags
 */
public data class GraphQueryArgs(
    public val description: Output<String>? = null,
    public val query: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val resourceName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resourcegraph.GraphQueryArgs> {
    override fun toJava(): com.pulumi.azurenative.resourcegraph.GraphQueryArgs =
        com.pulumi.azurenative.resourcegraph.GraphQueryArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .resourceName(resourceName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [GraphQueryArgs].
 */
@PulumiTagMarker
public class GraphQueryArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var query: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var resourceName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The description of a graph query.
     */
    @JvmName("ffcvoqoidfywmgnm")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value KQL query that will be graph.
     */
    @JvmName("gljqbyflgfnqqpdp")
    public suspend fun query(`value`: Output<String>) {
        this.query = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iowehjgxxgnctwdt")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Graph Query resource.
     */
    @JvmName("pushdckvbsagnaov")
    public suspend fun resourceName(`value`: Output<String>) {
        this.resourceName = value
    }

    /**
     * @param value Resource tags
     */
    @JvmName("xgmvfyxyaojiolfb")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The description of a graph query.
     */
    @JvmName("hudnmyqpnjeksqiy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value KQL query that will be graph.
     */
    @JvmName("hbinpnsxpeoukdtd")
    public suspend fun query(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pggwlhrtmgewwvcb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Graph Query resource.
     */
    @JvmName("jvjvknfnflserdnq")
    public suspend fun resourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceName = mapped
    }

    /**
     * @param value Resource tags
     */
    @JvmName("kpluijfkncamumbo")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags
     */
    @JvmName("aywerdsngfinrjrw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): GraphQueryArgs = GraphQueryArgs(
        description = description,
        query = query,
        resourceGroupName = resourceGroupName,
        resourceName = resourceName,
        tags = tags,
    )
}
