@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.DeploymentStackAtSubscriptionArgs.builder
import com.pulumi.azurenative.resources.kotlin.inputs.DenySettingsArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DenySettingsArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStackPropertiesActionOnUnmanageArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStackPropertiesActionOnUnmanageArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksDebugSettingArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksDebugSettingArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksParametersLinkArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksParametersLinkArgsBuilder
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksTemplateLinkArgs
import com.pulumi.azurenative.resources.kotlin.inputs.DeploymentStacksTemplateLinkArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Deployment stack object.
 * Azure REST API version: 2022-08-01-preview.
 * ## Example Usage
 * ### DeploymentStacksCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var deploymentStackAtSubscription = new AzureNative.Resources.DeploymentStackAtSubscription("deploymentStackAtSubscription", new()
 *     {
 *         ActionOnUnmanage = new AzureNative.Resources.Inputs.DeploymentStackPropertiesActionOnUnmanageArgs
 *         {
 *             ManagementGroups = "detach",
 *             ResourceGroups = "delete",
 *             Resources = "delete",
 *         },
 *         DenySettings = new AzureNative.Resources.Inputs.DenySettingsArgs
 *         {
 *             ApplyToChildScopes = false,
 *             ExcludedActions = new[]
 *             {
 *                 "action",
 *             },
 *             ExcludedPrincipals = new[]
 *             {
 *                 "principal",
 *             },
 *             Mode = "denyDelete",
 *         },
 *         DeploymentStackName = "simpleDeploymentStack",
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "parameter1",
 *             {
 *                 { "value", "a string" },
 *             } },
 *         },
 *         Tags =
 *         {
 *             { "tagkey", "tagVal" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewDeploymentStackAtSubscription(ctx, "deploymentStackAtSubscription", &resources.DeploymentStackAtSubscriptionArgs{
 * 			ActionOnUnmanage: &resources.DeploymentStackPropertiesActionOnUnmanageArgs{
 * 				ManagementGroups: pulumi.String("detach"),
 * 				ResourceGroups:   pulumi.String("delete"),
 * 				Resources:        pulumi.String("delete"),
 * 			},
 * 			DenySettings: &resources.DenySettingsArgs{
 * 				ApplyToChildScopes: pulumi.Bool(false),
 * 				ExcludedActions: pulumi.StringArray{
 * 					pulumi.String("action"),
 * 				},
 * 				ExcludedPrincipals: pulumi.StringArray{
 * 					pulumi.String("principal"),
 * 				},
 * 				Mode: pulumi.String("denyDelete"),
 * 			},
 * 			DeploymentStackName: pulumi.String("simpleDeploymentStack"),
 * 			Location:            pulumi.String("eastus"),
 * 			Parameters: pulumi.Any{
 * 				Parameter1: map[string]interface{}{
 * 					"value": "a string",
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tagkey": pulumi.String("tagVal"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.DeploymentStackAtSubscription;
 * import com.pulumi.azurenative.resources.DeploymentStackAtSubscriptionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var deploymentStackAtSubscription = new DeploymentStackAtSubscription("deploymentStackAtSubscription", DeploymentStackAtSubscriptionArgs.builder()
 *             .actionOnUnmanage(Map.ofEntries(
 *                 Map.entry("managementGroups", "detach"),
 *                 Map.entry("resourceGroups", "delete"),
 *                 Map.entry("resources", "delete")
 *             ))
 *             .denySettings(Map.ofEntries(
 *                 Map.entry("applyToChildScopes", false),
 *                 Map.entry("excludedActions", "action"),
 *                 Map.entry("excludedPrincipals", "principal"),
 *                 Map.entry("mode", "denyDelete")
 *             ))
 *             .deploymentStackName("simpleDeploymentStack")
 *             .location("eastus")
 *             .parameters(Map.of("parameter1", Map.of("value", "a string")))
 *             .tags(Map.of("tagkey", "tagVal"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:DeploymentStackAtSubscription simpleDeploymentStack /subscriptions/{subscriptionId}/providers/Microsoft.Resources/deploymentStacks/{deploymentStackName}
 * ```
 * @property actionOnUnmanage Defines the behavior of resources that are not managed immediately after the stack is updated.
 * @property debugSetting The debug setting of the deployment.
 * @property denySettings Defines how resources deployed by the stack are locked.
 * @property deploymentScope The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
 * @property deploymentStackName Name of the deployment stack.
 * @property description Deployment stack description.
 * @property location The location of the deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations.
 * @property parameters Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter values directly in the request, rather than linking to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
 * @property parametersLink The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
 * @property tags Deployment stack resource tags.
 * @property template The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
 * @property templateLink The URI of the template. Use either the templateLink property or the template property, but not both.
 */
public data class DeploymentStackAtSubscriptionArgs(
    public val actionOnUnmanage: Output<DeploymentStackPropertiesActionOnUnmanageArgs>? = null,
    public val debugSetting: Output<DeploymentStacksDebugSettingArgs>? = null,
    public val denySettings: Output<DenySettingsArgs>? = null,
    public val deploymentScope: Output<String>? = null,
    public val deploymentStackName: Output<String>? = null,
    public val description: Output<String>? = null,
    public val location: Output<String>? = null,
    public val parameters: Output<Any>? = null,
    public val parametersLink: Output<DeploymentStacksParametersLinkArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val template: Output<Any>? = null,
    public val templateLink: Output<DeploymentStacksTemplateLinkArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.DeploymentStackAtSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.DeploymentStackAtSubscriptionArgs =
        com.pulumi.azurenative.resources.DeploymentStackAtSubscriptionArgs.builder()
            .actionOnUnmanage(actionOnUnmanage?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .debugSetting(debugSetting?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .denySettings(denySettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deploymentScope(deploymentScope?.applyValue({ args0 -> args0 }))
            .deploymentStackName(deploymentStackName?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .parameters(parameters?.applyValue({ args0 -> args0 }))
            .parametersLink(parametersLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .template(template?.applyValue({ args0 -> args0 }))
            .templateLink(templateLink?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentStackAtSubscriptionArgs].
 */
@PulumiTagMarker
public class DeploymentStackAtSubscriptionArgsBuilder internal constructor() {
    private var actionOnUnmanage: Output<DeploymentStackPropertiesActionOnUnmanageArgs>? = null

    private var debugSetting: Output<DeploymentStacksDebugSettingArgs>? = null

    private var denySettings: Output<DenySettingsArgs>? = null

    private var deploymentScope: Output<String>? = null

    private var deploymentStackName: Output<String>? = null

    private var description: Output<String>? = null

    private var location: Output<String>? = null

    private var parameters: Output<Any>? = null

    private var parametersLink: Output<DeploymentStacksParametersLinkArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var template: Output<Any>? = null

    private var templateLink: Output<DeploymentStacksTemplateLinkArgs>? = null

    /**
     * @param value Defines the behavior of resources that are not managed immediately after the stack is updated.
     */
    @JvmName("cyyefwkjjbgujxxm")
    public suspend
    fun actionOnUnmanage(`value`: Output<DeploymentStackPropertiesActionOnUnmanageArgs>) {
        this.actionOnUnmanage = value
    }

    /**
     * @param value The debug setting of the deployment.
     */
    @JvmName("nogxvwjdffhqlynf")
    public suspend fun debugSetting(`value`: Output<DeploymentStacksDebugSettingArgs>) {
        this.debugSetting = value
    }

    /**
     * @param value Defines how resources deployed by the stack are locked.
     */
    @JvmName("gpoofvaiiugkivrn")
    public suspend fun denySettings(`value`: Output<DenySettingsArgs>) {
        this.denySettings = value
    }

    /**
     * @param value The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     */
    @JvmName("roadjsxxnwnlhioy")
    public suspend fun deploymentScope(`value`: Output<String>) {
        this.deploymentScope = value
    }

    /**
     * @param value Name of the deployment stack.
     */
    @JvmName("wpkyhacmlxhhrfbt")
    public suspend fun deploymentStackName(`value`: Output<String>) {
        this.deploymentStackName = value
    }

    /**
     * @param value Deployment stack description.
     */
    @JvmName("udpnxukklpxsypwv")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The location of the deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations.
     */
    @JvmName("briejvaqniidamot")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter values directly in the request, rather than linking to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("swsdrureqyktlocn")
    public suspend fun parameters(`value`: Output<Any>) {
        this.parameters = value
    }

    /**
     * @param value The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("cukbrdiavqcbxpbj")
    public suspend fun parametersLink(`value`: Output<DeploymentStacksParametersLinkArgs>) {
        this.parametersLink = value
    }

    /**
     * @param value Deployment stack resource tags.
     */
    @JvmName("lxcxxcjiajeffckd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("vwablfcwoxrkohkg")
    public suspend fun template(`value`: Output<Any>) {
        this.template = value
    }

    /**
     * @param value The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("ixgbtbunscfkshie")
    public suspend fun templateLink(`value`: Output<DeploymentStacksTemplateLinkArgs>) {
        this.templateLink = value
    }

    /**
     * @param value Defines the behavior of resources that are not managed immediately after the stack is updated.
     */
    @JvmName("ocmodtmrwomjxqpx")
    public suspend fun actionOnUnmanage(`value`: DeploymentStackPropertiesActionOnUnmanageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.actionOnUnmanage = mapped
    }

    /**
     * @param argument Defines the behavior of resources that are not managed immediately after the stack is updated.
     */
    @JvmName("xemhppvycoxrufuf")
    public suspend
    fun actionOnUnmanage(argument: suspend DeploymentStackPropertiesActionOnUnmanageArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentStackPropertiesActionOnUnmanageArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.actionOnUnmanage = mapped
    }

    /**
     * @param value The debug setting of the deployment.
     */
    @JvmName("ywbelmyaiiroknqa")
    public suspend fun debugSetting(`value`: DeploymentStacksDebugSettingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.debugSetting = mapped
    }

    /**
     * @param argument The debug setting of the deployment.
     */
    @JvmName("kjgtjdhytkwaptbs")
    public suspend
    fun debugSetting(argument: suspend DeploymentStacksDebugSettingArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentStacksDebugSettingArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.debugSetting = mapped
    }

    /**
     * @param value Defines how resources deployed by the stack are locked.
     */
    @JvmName("fqaknbwajqiobmlc")
    public suspend fun denySettings(`value`: DenySettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.denySettings = mapped
    }

    /**
     * @param argument Defines how resources deployed by the stack are locked.
     */
    @JvmName("wrfpfthbleymihwa")
    public suspend fun denySettings(argument: suspend DenySettingsArgsBuilder.() -> Unit) {
        val toBeMapped = DenySettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.denySettings = mapped
    }

    /**
     * @param value The scope at which the initial deployment should be created. If a scope is not specified, it will default to the scope of the deployment stack. Valid scopes are: management group (format: '/providers/Microsoft.Management/managementGroups/{managementGroupId}'), subscription (format: '/subscriptions/{subscriptionId}'), resource group (format: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}').
     */
    @JvmName("asfcltuqiyltksud")
    public suspend fun deploymentScope(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentScope = mapped
    }

    /**
     * @param value Name of the deployment stack.
     */
    @JvmName("ydtrpwukwpeprfdv")
    public suspend fun deploymentStackName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentStackName = mapped
    }

    /**
     * @param value Deployment stack description.
     */
    @JvmName("skvcfccddwsvwuad")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The location of the deployment stack. It cannot be changed after creation. It must be one of the supported Azure locations.
     */
    @JvmName("totpchdammnvaunm")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Name and value pairs that define the deployment parameters for the template. Use this element when providing the parameter values directly in the request, rather than linking to an existing parameter file. Use either the parametersLink property or the parameters property, but not both. It can be a JObject or a well formed JSON string.
     */
    @JvmName("jetcupfpiwwllity")
    public suspend fun parameters(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("wfbaqjnlpwffiqln")
    public suspend fun parametersLink(`value`: DeploymentStacksParametersLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parametersLink = mapped
    }

    /**
     * @param argument The URI of parameters file. Use this element to link to an existing parameters file. Use either the parametersLink property or the parameters property, but not both.
     */
    @JvmName("dvnwjjamgnllqqim")
    public suspend
    fun parametersLink(argument: suspend DeploymentStacksParametersLinkArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentStacksParametersLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.parametersLink = mapped
    }

    /**
     * @param value Deployment stack resource tags.
     */
    @JvmName("avfpjmwndlrxcbjd")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Deployment stack resource tags.
     */
    @JvmName("emuraijvtnrwndvl")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The template content. You use this element when you want to pass the template syntax directly in the request rather than link to an existing template. It can be a JObject or well-formed JSON string. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("wviscikvalkrhteo")
    public suspend fun template(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.template = mapped
    }

    /**
     * @param value The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("oxrkrphqcnfpuded")
    public suspend fun templateLink(`value`: DeploymentStacksTemplateLinkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateLink = mapped
    }

    /**
     * @param argument The URI of the template. Use either the templateLink property or the template property, but not both.
     */
    @JvmName("kacgubffkyhvrsch")
    public suspend
    fun templateLink(argument: suspend DeploymentStacksTemplateLinkArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentStacksTemplateLinkArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.templateLink = mapped
    }

    internal fun build(): DeploymentStackAtSubscriptionArgs = DeploymentStackAtSubscriptionArgs(
        actionOnUnmanage = actionOnUnmanage,
        debugSetting = debugSetting,
        denySettings = denySettings,
        deploymentScope = deploymentScope,
        deploymentStackName = deploymentStackName,
        description = description,
        location = location,
        parameters = parameters,
        parametersLink = parametersLink,
        tags = tags,
        template = template,
        templateLink = templateLink,
    )
}
