@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.ResourceGroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource group information.
 * Azure REST API version: 2022-09-01. Prior API version in Azure Native 1.x: 2019-05-01.
 * Other available API versions: 2018-02-01, 2023-07-01.
 * ## Example Usage
 * ### Create or update a resource group
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var resourceGroup = new AzureNative.Resources.ResourceGroup("resourceGroup", new()
 *     {
 *         Location = "eastus",
 *         ResourceGroupName = "my-resource-group",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewResourceGroup(ctx, "resourceGroup", &resources.ResourceGroupArgs{
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("my-resource-group"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.ResourceGroup;
 * import com.pulumi.azurenative.resources.ResourceGroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var resourceGroup = new ResourceGroup("resourceGroup", ResourceGroupArgs.builder()
 *             .location("eastus")
 *             .resourceGroupName("my-resource-group")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:ResourceGroup my-resource-group /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}
 * ```
 * @property location The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
 * @property managedBy The ID of the resource that manages this resource group.
 * @property resourceGroupName The name of the resource group to create or update. Can include alphanumeric, underscore, parentheses, hyphen, period (except at end), and Unicode characters that match the allowed characters.
 * @property tags The tags attached to the resource group.
 */
public data class ResourceGroupArgs(
    public val location: Output<String>? = null,
    public val managedBy: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.ResourceGroupArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.ResourceGroupArgs =
        com.pulumi.azurenative.resources.ResourceGroupArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .managedBy(managedBy?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ResourceGroupArgs].
 */
@PulumiTagMarker
public class ResourceGroupArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var managedBy: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
     */
    @JvmName("mpyjismeewkncafn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The ID of the resource that manages this resource group.
     */
    @JvmName("dysqckcbevgxbhcd")
    public suspend fun managedBy(`value`: Output<String>) {
        this.managedBy = value
    }

    /**
     * @param value The name of the resource group to create or update. Can include alphanumeric, underscore, parentheses, hyphen, period (except at end), and Unicode characters that match the allowed characters.
     */
    @JvmName("qppegipvmgiteyyb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The tags attached to the resource group.
     */
    @JvmName("kmbstvltnvtsnrdi")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The location of the resource group. It cannot be changed after the resource group has been created. It must be one of the supported Azure locations.
     */
    @JvmName("hylruwekhnxpoapk")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The ID of the resource that manages this resource group.
     */
    @JvmName("fiypgalrheobibbl")
    public suspend fun managedBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedBy = mapped
    }

    /**
     * @param value The name of the resource group to create or update. Can include alphanumeric, underscore, parentheses, hyphen, period (except at end), and Unicode characters that match the allowed characters.
     */
    @JvmName("hicrfdirluklbofo")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The tags attached to the resource group.
     */
    @JvmName("yasonrmjlrjgxwlv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values The tags attached to the resource group.
     */
    @JvmName("xtslbubeihqmrdfa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ResourceGroupArgs = ResourceGroupArgs(
        location = location,
        managedBy = managedBy,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
