@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin

import com.pulumi.azurenative.resources.TemplateSpecArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Template Spec object.
 * Azure REST API version: 2022-02-01. Prior API version in Azure Native 1.x: 2022-02-01.
 * ## Example Usage
 * ### TemplateSpecsCreateUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var templateSpec = new AzureNative.Resources.TemplateSpec("templateSpec", new()
 *     {
 *         Description = "A very simple Template Spec",
 *         Location = "eastus",
 *         ResourceGroupName = "templateSpecRG",
 *         TemplateSpecName = "simpleTemplateSpec",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/resources/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := resources.NewTemplateSpec(ctx, "templateSpec", &resources.TemplateSpecArgs{
 * 			Description:       pulumi.String("A very simple Template Spec"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("templateSpecRG"),
 * 			TemplateSpecName:  pulumi.String("simpleTemplateSpec"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.resources.TemplateSpec;
 * import com.pulumi.azurenative.resources.TemplateSpecArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var templateSpec = new TemplateSpec("templateSpec", TemplateSpecArgs.builder()
 *             .description("A very simple Template Spec")
 *             .location("eastus")
 *             .resourceGroupName("templateSpecRG")
 *             .templateSpecName("simpleTemplateSpec")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:resources:TemplateSpec simpleTemplateSpec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Resources/templateSpecs/{templateSpecName}
 * ```
 * @property description Template Spec description.
 * @property displayName Template Spec display name.
 * @property location The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations.
 * @property metadata The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property tags Resource tags.
 * @property templateSpecName Name of the Template Spec.
 */
public data class TemplateSpecArgs(
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val metadata: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val templateSpecName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.TemplateSpecArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.TemplateSpecArgs =
        com.pulumi.azurenative.resources.TemplateSpecArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .metadata(metadata?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .templateSpecName(templateSpecName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TemplateSpecArgs].
 */
@PulumiTagMarker
public class TemplateSpecArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var location: Output<String>? = null

    private var metadata: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var templateSpecName: Output<String>? = null

    /**
     * @param value Template Spec description.
     */
    @JvmName("ohxnmacjwxcgqmfx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Template Spec display name.
     */
    @JvmName("lrpfekjlpxxplrfc")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations.
     */
    @JvmName("kfdmwhyfblobjtgo")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    @JvmName("bbnftqonglcmcyqm")
    public suspend fun metadata(`value`: Output<Any>) {
        this.metadata = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("okdplkcojlwbslfp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tohonvtkbpbrrigg")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("ixsppfimrdrvvmjv")
    public suspend fun templateSpecName(`value`: Output<String>) {
        this.templateSpecName = value
    }

    /**
     * @param value Template Spec description.
     */
    @JvmName("pifffdhlekrdeqwx")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Template Spec display name.
     */
    @JvmName("emojackigexurxvw")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value The location of the Template Spec. It cannot be changed after Template Spec creation. It must be one of the supported Azure locations.
     */
    @JvmName("tumlleaplebxskrl")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The Template Spec metadata. Metadata is an open-ended object and is typically a collection of key-value pairs.
     */
    @JvmName("pnjvpcubcpielkcx")
    public suspend fun metadata(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("lfvvmfbbtwolvudv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nuryqkputaalcjpf")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("xtbntoroxppkldki")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Name of the Template Spec.
     */
    @JvmName("ngysmbjsnnbxkscj")
    public suspend fun templateSpecName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.templateSpecName = mapped
    }

    internal fun build(): TemplateSpecArgs = TemplateSpecArgs(
        description = description,
        displayName = displayName,
        location = location,
        metadata = metadata,
        resourceGroupName = resourceGroupName,
        tags = tags,
        templateSpecName = templateSpecName,
    )
}
