@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * denySettings Mode.
 */
public enum class DenySettingsMode(
    public val javaValue: com.pulumi.azurenative.resources.enums.DenySettingsMode,
) : ConvertibleToJava<com.pulumi.azurenative.resources.enums.DenySettingsMode> {
    /**
     * Authorized users are able to read and modify the resources, but cannot delete.
     */
    DenyDelete(com.pulumi.azurenative.resources.enums.DenySettingsMode.DenyDelete),

    /**
     * Authorized users can only read from a resource, but cannot modify or delete it.
     */
    DenyWriteAndDelete(com.pulumi.azurenative.resources.enums.DenySettingsMode.DenyWriteAndDelete),

    /**
     * No denyAssignments have been applied.
     */
    None(com.pulumi.azurenative.resources.enums.DenySettingsMode.None),
    ;

    override fun toJava(): com.pulumi.azurenative.resources.enums.DenySettingsMode = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.resources.enums.DenySettingsMode):
            DenySettingsMode = DenySettingsMode.values().first { it.javaValue == javaType }
    }
}
