@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.resources.kotlin.inputs

import com.pulumi.azurenative.resources.inputs.DeploymentStacksDebugSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The debug setting.
 * @property detailLevel Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information that is being passed in during deployment. By logging information about the request or response, sensitive data that is retrieved through the deployment operations could potentially be exposed.
 */
public data class DeploymentStacksDebugSettingArgs(
    public val detailLevel: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.resources.inputs.DeploymentStacksDebugSettingArgs> {
    override fun toJava(): com.pulumi.azurenative.resources.inputs.DeploymentStacksDebugSettingArgs =
        com.pulumi.azurenative.resources.inputs.DeploymentStacksDebugSettingArgs.builder()
            .detailLevel(detailLevel?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentStacksDebugSettingArgs].
 */
@PulumiTagMarker
public class DeploymentStacksDebugSettingArgsBuilder internal constructor() {
    private var detailLevel: Output<String>? = null

    /**
     * @param value Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information that is being passed in during deployment. By logging information about the request or response, sensitive data that is retrieved through the deployment operations could potentially be exposed.
     */
    @JvmName("lfpwvqqmvfkgyciw")
    public suspend fun detailLevel(`value`: Output<String>) {
        this.detailLevel = value
    }

    /**
     * @param value Specifies the type of information to log for debugging. The permitted values are none, requestContent, responseContent, or both requestContent and responseContent separated by a comma. The default is none. When setting this value, carefully consider the type of information that is being passed in during deployment. By logging information about the request or response, sensitive data that is retrieved through the deployment operations could potentially be exposed.
     */
    @JvmName("dmqdfargufwnuviv")
    public suspend fun detailLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detailLevel = mapped
    }

    internal fun build(): DeploymentStacksDebugSettingArgs = DeploymentStacksDebugSettingArgs(
        detailLevel = detailLevel,
    )
}
